/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.utils;

import android.os.Build;
import android.text.Layout;
import androidx.annotation.NonNull;

public abstract class LayoutUtils {
    private static final float DEFAULT_EXTRA = 0.0f;
    private static final float DEFAULT_MULTIPLIER = 1.0f;

    public static int getLineBottomWithoutPaddingAndSpacing(@NonNull Layout layout, int line) {
        int lineBottom;
        boolean hasLineSpacing;
        int bottom = layout.getLineBottom(line);
        boolean lastLineSpacingNotAdded = Build.VERSION.SDK_INT >= 19;
        boolean isSpanLastLine = line == layout.getLineCount() - 1;
        float lineSpacingExtra = layout.getSpacingAdd();
        float lineSpacingMultiplier = layout.getSpacingMultiplier();
        boolean bl = hasLineSpacing = lineSpacingExtra != 0.0f || lineSpacingMultiplier != 1.0f;
        if (!hasLineSpacing || isSpanLastLine && lastLineSpacingNotAdded) {
            lineBottom = bottom;
        } else {
            float extra;
            if (Float.compare(1.0f, lineSpacingMultiplier) != 0) {
                int lineHeight = LayoutUtils.getLineHeight(layout, line);
                extra = (float)lineHeight - ((float)lineHeight - lineSpacingExtra) / lineSpacingMultiplier;
            } else {
                extra = lineSpacingExtra;
            }
            lineBottom = (int)((float)bottom - extra + 0.5f);
        }
        if (isSpanLastLine && line == layout.getLineCount() - 1) {
            return lineBottom - layout.getBottomPadding();
        }
        return lineBottom;
    }

    public static int getLineTopWithoutPadding(@NonNull Layout layout, int line) {
        int top = layout.getLineTop(line);
        if (line == 0) {
            return top - layout.getTopPadding();
        }
        return top;
    }

    public static int getLineHeight(@NonNull Layout layout, int line) {
        return layout.getLineTop(line + 1) - layout.getLineTop(line);
    }

    private LayoutUtils() {
    }
}

