/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.core.spans;

import android.text.Spannable;
import android.text.Spanned;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.lang.ref.WeakReference;

public class TextViewSpan {
    private final WeakReference<TextView> reference;

    @Nullable
    public static TextView textViewOf(@NonNull CharSequence cs) {
        if (cs instanceof Spanned) {
            return TextViewSpan.textViewOf((Spanned)cs);
        }
        return null;
    }

    @Nullable
    public static TextView textViewOf(@NonNull Spanned spanned) {
        TextViewSpan[] spans = (TextViewSpan[])spanned.getSpans(0, spanned.length(), TextViewSpan.class);
        return spans != null && spans.length > 0 ? spans[0].textView() : null;
    }

    public static void applyTo(@NonNull Spannable spannable, @NonNull TextView textView) {
        TextViewSpan[] spans = (TextViewSpan[])spannable.getSpans(0, spannable.length(), TextViewSpan.class);
        if (spans != null) {
            for (TextViewSpan span : spans) {
                spannable.removeSpan((Object)span);
            }
        }
        TextViewSpan span = new TextViewSpan(textView);
        spannable.setSpan((Object)span, 0, spannable.length(), 18);
    }

    public TextViewSpan(@NonNull TextView textView) {
        this.reference = new WeakReference<TextView>(textView);
    }

    @Nullable
    public TextView textView() {
        return (TextView)this.reference.get();
    }
}

