/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.core.spans;

import android.text.Layout;
import android.text.Spannable;
import android.text.Spanned;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.lang.ref.WeakReference;

public class TextLayoutSpan {
    private final WeakReference<Layout> reference;

    @Nullable
    public static Layout layoutOf(@NonNull CharSequence cs) {
        if (cs instanceof Spanned) {
            return TextLayoutSpan.layoutOf((Spanned)cs);
        }
        return null;
    }

    @Nullable
    public static Layout layoutOf(@NonNull Spanned spanned) {
        TextLayoutSpan[] spans = (TextLayoutSpan[])spanned.getSpans(0, spanned.length(), TextLayoutSpan.class);
        return spans != null && spans.length > 0 ? spans[0].layout() : null;
    }

    public static void applyTo(@NonNull Spannable spannable, @NonNull Layout layout) {
        TextLayoutSpan[] spans = (TextLayoutSpan[])spannable.getSpans(0, spannable.length(), TextLayoutSpan.class);
        if (spans != null) {
            for (TextLayoutSpan span : spans) {
                spannable.removeSpan((Object)span);
            }
        }
        TextLayoutSpan span = new TextLayoutSpan(layout);
        spannable.setSpan((Object)span, 0, spannable.length(), 18);
    }

    TextLayoutSpan(@NonNull Layout layout) {
        this.reference = new WeakReference<Layout>(layout);
    }

    @Nullable
    public Layout layout() {
        return (Layout)this.reference.get();
    }
}

