/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.core.spans;

import android.graphics.Typeface;
import android.text.TextPaint;
import android.text.style.MetricAffectingSpan;
import androidx.annotation.NonNull;

public class CustomTypefaceSpan
extends MetricAffectingSpan {
    private final Typeface typeface;
    private final boolean mergeStyles;

    @NonNull
    public static CustomTypefaceSpan create(@NonNull Typeface typeface) {
        return CustomTypefaceSpan.create(typeface, false);
    }

    @NonNull
    public static CustomTypefaceSpan create(@NonNull Typeface typeface, boolean mergeStyles) {
        return new CustomTypefaceSpan(typeface, mergeStyles);
    }

    @Deprecated
    public CustomTypefaceSpan(@NonNull Typeface typeface) {
        this(typeface, false);
    }

    CustomTypefaceSpan(@NonNull Typeface typeface, boolean mergeStyles) {
        this.typeface = typeface;
        this.mergeStyles = mergeStyles;
    }

    public void updateMeasureState(@NonNull TextPaint paint) {
        this.updatePaint(paint);
    }

    public void updateDrawState(@NonNull TextPaint paint) {
        this.updatePaint(paint);
    }

    private void updatePaint(@NonNull TextPaint paint) {
        Typeface oldTypeface = paint.getTypeface();
        if (!this.mergeStyles || oldTypeface == null || oldTypeface.getStyle() == 0) {
            paint.setTypeface(this.typeface);
        } else {
            int oldStyle = oldTypeface.getStyle();
            int want = oldStyle | this.typeface.getStyle();
            Typeface styledTypeface = Typeface.create((Typeface)this.typeface, (int)want);
            paint.setTypeface(styledTypeface);
        }
    }
}

