/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.core.spans;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.Layout;
import android.text.TextPaint;
import android.text.style.LeadingMarginSpan;
import android.text.style.MetricAffectingSpan;
import androidx.annotation.NonNull;
import io.noties.markwon.core.MarkwonTheme;
import io.noties.markwon.core.spans.ObjectsPool;

public class CodeBlockSpan
extends MetricAffectingSpan
implements LeadingMarginSpan {
    private final MarkwonTheme theme;
    private final Rect rect = ObjectsPool.rect();
    private final Paint paint = ObjectsPool.paint();

    public CodeBlockSpan(@NonNull MarkwonTheme theme) {
        this.theme = theme;
    }

    public void updateMeasureState(TextPaint p) {
        this.apply(p);
    }

    public void updateDrawState(TextPaint ds) {
        this.apply(ds);
    }

    private void apply(TextPaint p) {
        this.theme.applyCodeBlockTextStyle((Paint)p);
    }

    public int getLeadingMargin(boolean first) {
        return this.theme.getCodeBlockMargin();
    }

    public void drawLeadingMargin(Canvas c, Paint p, int x, int dir, int top, int baseline, int bottom, CharSequence text, int start, int end, boolean first, Layout layout) {
        int right;
        int left;
        this.paint.setStyle(Paint.Style.FILL);
        this.paint.setColor(this.theme.getCodeBlockBackgroundColor(p));
        if (dir > 0) {
            left = x;
            right = c.getWidth();
        } else {
            left = x - c.getWidth();
            right = x;
        }
        this.rect.set(left, top, right, bottom);
        c.drawRect(this.rect, this.paint);
    }
}

