/*
 * Decompiled with CFR 0.152.
 */
package io.noties.markwon.core.spans;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.text.Layout;
import android.text.style.LeadingMarginSpan;
import androidx.annotation.NonNull;
import io.noties.markwon.core.MarkwonTheme;
import io.noties.markwon.core.spans.ObjectsPool;

public class BlockQuoteSpan
implements LeadingMarginSpan {
    private final MarkwonTheme theme;
    private final Rect rect = ObjectsPool.rect();
    private final Paint paint = ObjectsPool.paint();

    public BlockQuoteSpan(@NonNull MarkwonTheme theme) {
        this.theme = theme;
    }

    public int getLeadingMargin(boolean first) {
        return this.theme.getBlockMargin();
    }

    public void drawLeadingMargin(Canvas c, Paint p, int x, int dir, int top, int baseline, int bottom, CharSequence text, int start, int end, boolean first, Layout layout) {
        int width = this.theme.getBlockQuoteWidth();
        this.paint.set(p);
        this.theme.applyBlockQuoteStyle(this.paint);
        int l = x + dir * width;
        int r = l + dir * width;
        int left = Math.min(l, r);
        int right = Math.max(l, r);
        this.rect.set(left, top, right, bottom);
        c.drawRect(this.rect, this.paint);
    }
}

