/*
 * Decompiled with CFR 0.152.
 */
package io.nlopez.compose.rules;

import io.nlopez.rules.core.ComposeKtConfig;
import io.nlopez.rules.core.ComposeKtVisitor;
import io.nlopez.rules.core.Emitter;
import io.nlopez.rules.core.util.ASTNodesKt;
import io.nlopez.rules.core.util.PreviewsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;

@Metadata(mv={2, 0, 0}, k=1, xi=82, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lio/nlopez/compose/rules/PreviewPublic;", "Lio/nlopez/rules/core/ComposeKtVisitor;", "<init>", "()V", "visitComposable", "", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "autoCorrect", "", "emitter", "Lio/nlopez/rules/core/Emitter;", "config", "Lio/nlopez/rules/core/ComposeKtConfig;", "Companion", "common"})
public final class PreviewPublic
implements ComposeKtVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String ComposablesPreviewShouldNotBePublic = "Composables annotated with @Preview that are used only for previewing the UI should not be public.\n\nSee https://mrmans0n.github.io/compose-rules/rules/#preview-composables-should-not-be-public for more information.";

    public void visitComposable(@NotNull KtFunction function, boolean autoCorrect, @NotNull Emitter emitter, @NotNull ComposeKtConfig config) {
        Intrinsics.checkNotNullParameter((Object)function, (String)"function");
        Intrinsics.checkNotNullParameter((Object)emitter, (String)"emitter");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (!PreviewsKt.isPreview((KtAnnotated)((KtAnnotated)function))) {
            return;
        }
        if (!KtPsiUtilKt.isPublic((KtModifierListOwner)((KtModifierListOwner)function))) {
            return;
        }
        emitter.report((PsiElement)function, ComposablesPreviewShouldNotBePublic, true);
        if (autoCorrect) {
            ASTNode aSTNode = function.getNode().findChildByType((IElementType)KtTokens.FUN_KEYWORD);
            ASTNode aSTNode2 = aSTNode != null ? ASTNodesKt.firstChildLeafOrSelf((ASTNode)aSTNode) : null;
            LeafPsiElement leafPsiElement = aSTNode2 instanceof LeafPsiElement ? (LeafPsiElement)aSTNode2 : null;
            if (leafPsiElement == null) {
                return;
            }
            LeafPsiElement node = leafPsiElement;
            node.rawReplaceWithText(KtTokens.PRIVATE_KEYWORD.getValue() + " " + KtTokens.FUN_KEYWORD.getValue());
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=82, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/nlopez/compose/rules/PreviewPublic$Companion;", "", "<init>", "()V", "ComposablesPreviewShouldNotBePublic", "", "getComposablesPreviewShouldNotBePublic", "()Ljava/lang/String;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getComposablesPreviewShouldNotBePublic() {
            return ComposablesPreviewShouldNotBePublic;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

