/*
 * Decompiled with CFR 0.152.
 */
package io.nlopez.compose.rules;

import io.nlopez.rules.core.ComposeKtConfig;
import io.nlopez.rules.core.ComposeKtVisitor;
import io.nlopez.rules.core.Emitter;
import io.nlopez.rules.core.EmitterKt;
import io.nlopez.rules.core.util.PreviewsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtClass;

@Metadata(mv={2, 0, 0}, k=1, xi=82, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lio/nlopez/compose/rules/PreviewAnnotationNaming;", "Lio/nlopez/rules/core/ComposeKtVisitor;", "<init>", "()V", "visitClass", "", "clazz", "Lorg/jetbrains/kotlin/psi/KtClass;", "autoCorrect", "", "emitter", "Lio/nlopez/rules/core/Emitter;", "config", "Lio/nlopez/rules/core/ComposeKtConfig;", "Companion", "common"})
public final class PreviewAnnotationNaming
implements ComposeKtVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String PreviewAnnotationDoesNotStartWithPreview = "MultiPreview annotations should start with `Preview` as prefix.\n\nSee https://mrmans0n.github.io/compose-rules/rules/#naming-multipreview-annotations-properly for more information.";

    public void visitClass(@NotNull KtClass clazz, boolean autoCorrect, @NotNull Emitter emitter, @NotNull ComposeKtConfig config) {
        Intrinsics.checkNotNullParameter((Object)clazz, (String)"clazz");
        Intrinsics.checkNotNullParameter((Object)emitter, (String)"emitter");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        if (!clazz.isAnnotation()) {
            return;
        }
        if (!PreviewsKt.isPreview((KtAnnotated)((KtAnnotated)clazz))) {
            return;
        }
        String string = clazz.getNameAsSafeName().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        String name = string;
        if (!StringsKt.startsWith$default((String)name, (String)"Preview", (boolean)false, (int)2, null)) {
            EmitterKt.report((Emitter)emitter, (PsiElement)((PsiElement)clazz), (String)PreviewAnnotationDoesNotStartWithPreview);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=82, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lio/nlopez/compose/rules/PreviewAnnotationNaming$Companion;", "", "<init>", "()V", "PreviewAnnotationDoesNotStartWithPreview", "", "getPreviewAnnotationDoesNotStartWithPreview", "()Ljava/lang/String;", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getPreviewAnnotationDoesNotStartWithPreview() {
            return PreviewAnnotationDoesNotStartWithPreview;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

