/*
 * Decompiled with CFR 0.152.
 */
package io.nlopez.compose.rules;

import io.nlopez.rules.core.ComposeKtConfig;
import io.nlopez.rules.core.ComposeKtVisitor;
import io.nlopez.rules.core.Emitter;
import io.nlopez.rules.core.EmitterKt;
import io.nlopez.rules.core.util.KtFunctionsKt;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtFunction;

@Metadata(mv={2, 0, 0}, k=1, xi=82, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lio/nlopez/compose/rules/Naming;", "Lio/nlopez/rules/core/ComposeKtVisitor;", "<init>", "()V", "visitComposable", "", "function", "Lorg/jetbrains/kotlin/psi/KtFunction;", "autoCorrect", "", "emitter", "Lio/nlopez/rules/core/Emitter;", "config", "Lio/nlopez/rules/core/ComposeKtConfig;", "Companion", "common"})
@SourceDebugExtension(value={"SMAP\nNaming.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Naming.kt\nio/nlopez/compose/rules/Naming\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n1#2:69\n1747#3,3:70\n*S KotlinDebug\n*F\n+ 1 Naming.kt\nio/nlopez/compose/rules/Naming\n*L\n36#1:70,3\n*E\n"})
public final class Naming
implements ComposeKtVisitor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String ComposablesThatDoNotReturnResultsShouldBeCapitalized = "Composable functions that return Unit should start with an uppercase letter.\nThey are considered declarative entities that can be either present or absent in a composition and therefore follow the naming rules for classes.\n\nSee https://mrmans0n.github.io/compose-rules/rules/#naming-composable-functions-properly for more information.";
    @NotNull
    private static final String ComposablesThatReturnResultsShouldBeLowercase = "Composable functions that return a value should start with a lowercase letter.\nWhile useful and accepted outside of @Composable functions, this factory function convention has drawbacks that set inappropriate expectations for callers when used with @Composable functions.\n\nSee https://mrmans0n.github.io/compose-rules/rules/#naming-composable-functions-properly for more information.";

    /*
     * WARNING - void declaration
     */
    public void visitComposable(@NotNull KtFunction function, boolean autoCorrect, @NotNull Emitter emitter, @NotNull ComposeKtConfig config) {
        Object object;
        Object object2;
        block17: {
            block16: {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                Intrinsics.checkNotNullParameter((Object)emitter, (String)"emitter");
                Intrinsics.checkNotNullParameter((Object)config, (String)"config");
                if (!function.hasBlockBody()) {
                    return;
                }
                if (KtFunctionsKt.isOperator((KtFunction)function)) {
                    return;
                }
                object2 = function.getName();
                if (object2 == null) break block16;
                object = object2;
                String p0 = object;
                boolean bl = false;
                object2 = !(((CharSequence)p0).length() == 0) ? object : null;
                if (object2 != null) break block17;
            }
            return;
        }
        String functionName = object2;
        char firstLetter = StringsKt.first((CharSequence)functionName);
        if (KtFunctionsKt.getReturnsValue((KtFunction)function)) {
            if (Character.isUpperCase(firstLetter)) {
                boolean isAllowed;
                block15: {
                    boolean bl;
                    void $this$any$iv;
                    object = config.getSet("allowedComposableFunctionNames", SetsKt.emptySet());
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            if (!new Regex(it).matches((CharSequence)functionName)) continue;
                            bl = true;
                            break block15;
                        }
                        bl = isAllowed = false;
                    }
                }
                if (isAllowed) {
                    return;
                }
                EmitterKt.report((Emitter)emitter, (PsiElement)((PsiElement)function), (String)ComposablesThatReturnResultsShouldBeLowercase);
            }
        } else if (Character.isLowerCase(firstLetter) && !KtFunctionsKt.getHasReceiverType((KtFunction)function)) {
            EmitterKt.report((Emitter)emitter, (PsiElement)((PsiElement)function), (String)ComposablesThatDoNotReturnResultsShouldBeCapitalized);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=82, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lio/nlopez/compose/rules/Naming$Companion;", "", "<init>", "()V", "ComposablesThatDoNotReturnResultsShouldBeCapitalized", "", "getComposablesThatDoNotReturnResultsShouldBeCapitalized", "()Ljava/lang/String;", "ComposablesThatReturnResultsShouldBeLowercase", "getComposablesThatReturnResultsShouldBeLowercase", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getComposablesThatDoNotReturnResultsShouldBeCapitalized() {
            return ComposablesThatDoNotReturnResultsShouldBeCapitalized;
        }

        @NotNull
        public final String getComposablesThatReturnResultsShouldBeLowercase() {
            return ComposablesThatReturnResultsShouldBeLowercase;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

