/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.unix;

import io.netty5.buffer.Buffer;
import io.netty5.channel.socket.DatagramPacket;
import io.netty5.util.internal.ObjectUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class SegmentedDatagramPacket
extends DatagramPacket {
    private final int segmentSize;

    public SegmentedDatagramPacket(Buffer message, int segmentSize, SocketAddress recipient, SocketAddress sender) {
        super(message, recipient, sender);
        this.segmentSize = ObjectUtil.checkPositive((int)segmentSize, (String)"segmentSize");
    }

    public SegmentedDatagramPacket(Buffer message, int segmentSize, InetSocketAddress recipient) {
        super(message, (SocketAddress)recipient);
        this.segmentSize = ObjectUtil.checkPositive((int)segmentSize, (String)"segmentSize");
    }

    public int segmentSize() {
        return this.segmentSize;
    }

    public SegmentedDatagramPacket replace(Buffer content) {
        return new SegmentedDatagramPacket(content, this.segmentSize, this.recipient(), this.sender());
    }

    public SegmentedDatagramPacket touch(Object hint) {
        super.touch(hint);
        return this;
    }
}

