/*
 * Decompiled with CFR 0.152.
 */
package io.netty5.channel.unix;

import io.netty5.buffer.BufferComponent;
import io.netty5.buffer.ComponentIterator;
import io.netty5.channel.unix.Buffer;
import io.netty5.channel.unix.Limits;
import io.netty5.util.internal.ObjectUtil;
import io.netty5.util.internal.PlatformDependent;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.function.Predicate;

public final class IovArray
implements Predicate<Object> {
    private static final int ADDRESS_SIZE = Buffer.addressSize();
    public static final int IOV_SIZE = 2 * ADDRESS_SIZE;
    private static final int MAX_CAPACITY = Limits.IOV_MAX * IOV_SIZE;
    private final long memoryAddress;
    private final ByteBuffer memory;
    private int count;
    private long size;
    private long maxBytes = Limits.SSIZE_MAX;

    public IovArray() {
        this(Buffer.allocateDirectWithNativeOrder(MAX_CAPACITY));
    }

    public IovArray(ByteBuffer memory) {
        assert (memory.position() == 0);
        if (!memory.isDirect()) {
            memory = ByteBuffer.allocateDirect(memory.capacity());
        }
        if (memory.order() != ByteOrder.nativeOrder()) {
            memory.order(ByteOrder.nativeOrder());
        }
        this.memory = memory;
        this.memoryAddress = Buffer.nativeAddressOf(memory);
    }

    public void clear() {
        this.count = 0;
        this.size = 0L;
    }

    private boolean add(long memoryAddress, long addr, int len) {
        assert (addr != 0L);
        if (this.maxBytes - (long)len < this.size && this.count > 0 || this.memory.capacity() < (this.count + 1) * IOV_SIZE) {
            return false;
        }
        int baseOffset = IovArray.idx(this.count);
        int lengthOffset = baseOffset + ADDRESS_SIZE;
        this.size += (long)len;
        ++this.count;
        if (ADDRESS_SIZE == 8) {
            if (PlatformDependent.hasUnsafe()) {
                PlatformDependent.putLong((long)((long)baseOffset + memoryAddress), (long)addr);
                PlatformDependent.putLong((long)((long)lengthOffset + memoryAddress), (long)len);
            } else {
                this.memory.putLong(baseOffset, addr);
                this.memory.putLong(lengthOffset, len);
            }
        } else {
            assert (ADDRESS_SIZE == 4);
            if (PlatformDependent.hasUnsafe()) {
                PlatformDependent.putInt((long)((long)baseOffset + memoryAddress), (int)((int)addr));
                PlatformDependent.putInt((long)((long)lengthOffset + memoryAddress), (int)len);
            } else {
                this.memory.putInt(baseOffset, (int)addr);
                this.memory.putInt(lengthOffset, len);
            }
        }
        return true;
    }

    public int writtenMessages(int index, long totalBytes) {
        if (index == 0 && totalBytes == this.size) {
            return this.count;
        }
        int num = 0;
        while (index < this.count && totalBytes > 0L) {
            long len;
            int baseOffset = IovArray.idx(index);
            int lengthOffset = baseOffset + ADDRESS_SIZE;
            if (ADDRESS_SIZE == 8) {
                len = PlatformDependent.hasUnsafe() ? PlatformDependent.getLong((long)((long)lengthOffset + this.memoryAddress)) : this.memory.getLong(lengthOffset);
            } else {
                assert (ADDRESS_SIZE == 4);
                len = PlatformDependent.hasUnsafe() ? (long)PlatformDependent.getInt((long)((long)lengthOffset + this.memoryAddress)) : (long)this.memory.getInt(lengthOffset);
            }
            totalBytes -= len;
            ++num;
        }
        return num;
    }

    public int count() {
        return this.count;
    }

    public long size() {
        return this.size;
    }

    public void maxBytes(long maxBytes) {
        this.maxBytes = Math.min(Limits.SSIZE_MAX, ObjectUtil.checkPositive((long)maxBytes, (String)"maxBytes"));
    }

    public long maxBytes() {
        return this.maxBytes;
    }

    public long memoryAddress(int index) {
        return this.memoryAddress + (long)IovArray.idx(index);
    }

    public void release() {
        Buffer.free(this.memory);
    }

    @Override
    public boolean test(Object msg) {
        if (msg instanceof io.netty5.buffer.Buffer) {
            io.netty5.buffer.Buffer buffer = (io.netty5.buffer.Buffer)msg;
            if (buffer.readableBytes() == 0) {
                return true;
            }
            return this.addReadable(buffer);
        }
        return false;
    }

    public boolean addReadable(io.netty5.buffer.Buffer buffer) {
        try (ComponentIterator iteration = buffer.forEachComponent();){
            BufferComponent c = (BufferComponent)iteration.firstReadable();
            while (c != null) {
                if (!this.addReadable(c, c.readableBytes())) {
                    boolean bl = false;
                    return bl;
                }
                c = (BufferComponent)((ComponentIterator.Next)c).nextReadable();
            }
        }
        return true;
    }

    public boolean addReadable(BufferComponent component, int byteCount) {
        if (this.count == Limits.IOV_MAX) {
            return false;
        }
        long nativeAddress = component.readableNativeAddress();
        assert (nativeAddress != 0L);
        return this.add(this.memoryAddress, nativeAddress, byteCount);
    }

    public boolean addWritable(io.netty5.buffer.Buffer buffer) {
        try (ComponentIterator iteration = buffer.forEachComponent();){
            BufferComponent c = (BufferComponent)iteration.firstWritable();
            while (c != null) {
                if (!this.addWritable(c, c.writableBytes())) {
                    boolean bl = false;
                    return bl;
                }
                c = (BufferComponent)((ComponentIterator.Next)c).nextWritable();
            }
        }
        return true;
    }

    public boolean addWritable(BufferComponent component, int byteCount) {
        if (this.count == Limits.IOV_MAX) {
            return false;
        }
        long nativeAddress = component.writableNativeAddress();
        assert (nativeAddress != 0L);
        return this.add(this.memoryAddress, nativeAddress, byteCount);
    }

    private static int idx(int index) {
        return IOV_SIZE * index;
    }
}

