/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.unix.tests;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.ServerChannel;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public abstract class DetectPeerCloseWithoutReadTest {
    protected abstract EventLoopGroup newGroup();

    protected abstract Class<? extends ServerChannel> serverChannel();

    protected abstract Class<? extends Channel> clientChannel();

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void clientCloseWithoutServerReadIsDetectedNoExtraReadRequested() throws InterruptedException {
        this.clientCloseWithoutServerReadIsDetected0(false);
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void clientCloseWithoutServerReadIsDetectedExtraReadRequested() throws InterruptedException {
        this.clientCloseWithoutServerReadIsDetected0(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clientCloseWithoutServerReadIsDetected0(final boolean extraReadRequested) throws InterruptedException {
        EventLoopGroup serverGroup = null;
        EventLoopGroup clientGroup = null;
        Channel serverChannel = null;
        try {
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicInteger bytesRead = new AtomicInteger();
            int expectedBytes = 100;
            serverGroup = this.newGroup();
            clientGroup = this.newGroup();
            ServerBootstrap sb = new ServerBootstrap();
            sb.group(serverGroup);
            sb.channel(this.serverChannel());
            sb.childOption(ChannelOption.AUTO_READ, (Object)false);
            sb.childOption(ChannelOption.MAX_MESSAGES_PER_READ, (Object)1);
            sb.childOption(ChannelOption.RCVBUF_ALLOCATOR, (Object)new FixedRecvByteBufAllocator(10));
            sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{new TestHandler(bytesRead, extraReadRequested, latch)});
                }
            });
            serverChannel = sb.bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
            Bootstrap cb = new Bootstrap();
            cb.group(serverGroup);
            cb.channel(this.clientChannel());
            cb.handler((ChannelHandler)new ChannelInboundHandlerAdapter());
            Channel clientChannel = cb.connect(serverChannel.localAddress()).syncUninterruptibly().channel();
            ByteBuf buf = clientChannel.alloc().buffer(100);
            buf.writerIndex(buf.writerIndex() + 100);
            clientChannel.writeAndFlush((Object)buf).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            latch.await();
            Assertions.assertEquals((int)100, (int)bytesRead.get());
        }
        finally {
            if (serverChannel != null) {
                serverChannel.close().syncUninterruptibly();
            }
            if (serverGroup != null) {
                serverGroup.shutdownGracefully();
            }
            if (clientGroup != null) {
                clientGroup.shutdownGracefully();
            }
        }
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void serverCloseWithoutClientReadIsDetectedNoExtraReadRequested() throws InterruptedException {
        this.serverCloseWithoutClientReadIsDetected0(false);
    }

    @Test
    @Timeout(value=10000L, unit=TimeUnit.MILLISECONDS)
    public void serverCloseWithoutClientReadIsDetectedExtraReadRequested() throws InterruptedException {
        this.serverCloseWithoutClientReadIsDetected0(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void serverCloseWithoutClientReadIsDetected0(final boolean extraReadRequested) throws InterruptedException {
        EventLoopGroup serverGroup = null;
        EventLoopGroup clientGroup = null;
        Channel serverChannel = null;
        Channel clientChannel = null;
        try {
            final CountDownLatch latch = new CountDownLatch(1);
            final AtomicInteger bytesRead = new AtomicInteger();
            int expectedBytes = 100;
            serverGroup = this.newGroup();
            clientGroup = this.newGroup();
            ServerBootstrap sb = new ServerBootstrap();
            sb.group(serverGroup);
            sb.channel(this.serverChannel());
            sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                        public void channelActive(ChannelHandlerContext ctx) {
                            ByteBuf buf = ctx.alloc().buffer(100);
                            buf.writerIndex(buf.writerIndex() + 100);
                            ctx.writeAndFlush((Object)buf).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                            ctx.fireChannelActive();
                        }
                    }});
                }
            });
            serverChannel = sb.bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
            Bootstrap cb = new Bootstrap();
            cb.group(serverGroup);
            cb.channel(this.clientChannel());
            cb.option(ChannelOption.AUTO_READ, (Object)false);
            cb.option(ChannelOption.MAX_MESSAGES_PER_READ, (Object)1);
            cb.option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new FixedRecvByteBufAllocator(10));
            cb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{new TestHandler(bytesRead, extraReadRequested, latch)});
                }
            });
            clientChannel = cb.connect(serverChannel.localAddress()).syncUninterruptibly().channel();
            latch.await();
            Assertions.assertEquals((int)100, (int)bytesRead.get());
        }
        finally {
            if (serverChannel != null) {
                serverChannel.close().syncUninterruptibly();
            }
            if (clientChannel != null) {
                clientChannel.close().syncUninterruptibly();
            }
            if (serverGroup != null) {
                serverGroup.shutdownGracefully();
            }
            if (clientGroup != null) {
                clientGroup.shutdownGracefully();
            }
        }
    }

    private static final class TestHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        private final AtomicInteger bytesRead;
        private final boolean extraReadRequested;
        private final CountDownLatch latch;

        TestHandler(AtomicInteger bytesRead, boolean extraReadRequested, CountDownLatch latch) {
            this.bytesRead = bytesRead;
            this.extraReadRequested = extraReadRequested;
            this.latch = latch;
        }

        protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) {
            this.bytesRead.addAndGet(msg.readableBytes());
            if (this.extraReadRequested) {
                ctx.read();
            }
        }

        public void channelInactive(ChannelHandlerContext ctx) {
            this.latch.countDown();
            ctx.fireChannelInactive();
        }
    }
}

