/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.uring;

import io.netty.buffer.ByteBuf;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.EventLoop;
import io.netty.channel.IoOps;
import io.netty.channel.IoRegistration;
import io.netty.channel.socket.DuplexChannel;
import io.netty.channel.unix.Errors;
import io.netty.channel.unix.IovArray;
import io.netty.channel.uring.AbstractIoUringChannel;
import io.netty.channel.uring.IoUring;
import io.netty.channel.uring.IoUringBufferRing;
import io.netty.channel.uring.IoUringFileRegion;
import io.netty.channel.uring.IoUringIoHandler;
import io.netty.channel.uring.IoUringIoOps;
import io.netty.channel.uring.IoUringRecvByteAllocatorHandle;
import io.netty.channel.uring.IoUringStreamChannelConfig;
import io.netty.channel.uring.LinuxSocket;
import io.netty.channel.uring.Native;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.IOException;
import java.net.SocketAddress;

abstract class AbstractIoUringStreamChannel
extends AbstractIoUringChannel
implements DuplexChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(AbstractIoUringStreamChannel.class);
    private static final ChannelMetadata METADATA = new ChannelMetadata(false, 16);
    byte writeOpCode;
    long writeId;
    byte readOpCode;
    long readId;
    private IoUringBufferRing bufferRing;

    AbstractIoUringStreamChannel(Channel parent, LinuxSocket socket, boolean active) {
        super(parent, socket, active);
    }

    AbstractIoUringStreamChannel(Channel parent, LinuxSocket socket, SocketAddress remote) {
        super(parent, socket, remote);
    }

    public ChannelMetadata metadata() {
        return METADATA;
    }

    protected AbstractIoUringChannel.AbstractUringUnsafe newUnsafe() {
        return new IoUringStreamUnsafe();
    }

    public final ChannelFuture shutdown() {
        return this.shutdown(this.newPromise());
    }

    public final ChannelFuture shutdown(final ChannelPromise promise) {
        ChannelFuture shutdownOutputFuture = this.shutdownOutput();
        if (shutdownOutputFuture.isDone()) {
            this.shutdownOutputDone(shutdownOutputFuture, promise);
        } else {
            shutdownOutputFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture shutdownOutputFuture) throws Exception {
                    AbstractIoUringStreamChannel.this.shutdownOutputDone(shutdownOutputFuture, promise);
                }
            });
        }
        return promise;
    }

    protected final void doShutdownOutput() throws Exception {
        this.socket.shutdown(false, true);
    }

    private void shutdownInput0(ChannelPromise promise) {
        try {
            this.socket.shutdown(true, false);
            promise.setSuccess();
        }
        catch (Throwable cause) {
            promise.setFailure(cause);
        }
    }

    public final boolean isOutputShutdown() {
        return this.socket.isOutputShutdown();
    }

    public final boolean isInputShutdown() {
        return this.socket.isInputShutdown();
    }

    public final boolean isShutdown() {
        return this.socket.isShutdown();
    }

    public final ChannelFuture shutdownOutput() {
        return this.shutdownOutput(this.newPromise());
    }

    public final ChannelFuture shutdownOutput(final ChannelPromise promise) {
        EventLoop loop = this.eventLoop();
        if (loop.inEventLoop()) {
            ((AbstractChannel.AbstractUnsafe)this.unsafe()).shutdownOutput(promise);
        } else {
            loop.execute(new Runnable(){

                @Override
                public void run() {
                    ((AbstractChannel.AbstractUnsafe)AbstractIoUringStreamChannel.this.unsafe()).shutdownOutput(promise);
                }
            });
        }
        return promise;
    }

    public final ChannelFuture shutdownInput() {
        return this.shutdownInput(this.newPromise());
    }

    public final ChannelFuture shutdownInput(final ChannelPromise promise) {
        EventLoop loop = this.eventLoop();
        if (loop.inEventLoop()) {
            this.shutdownInput0(promise);
        } else {
            loop.execute(new Runnable(){

                @Override
                public void run() {
                    AbstractIoUringStreamChannel.this.shutdownInput0(promise);
                }
            });
        }
        return promise;
    }

    private void shutdownOutputDone(final ChannelFuture shutdownOutputFuture, final ChannelPromise promise) {
        ChannelFuture shutdownInputFuture = this.shutdownInput();
        if (shutdownInputFuture.isDone()) {
            AbstractIoUringStreamChannel.shutdownDone(shutdownOutputFuture, shutdownInputFuture, promise);
        } else {
            shutdownInputFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture shutdownInputFuture) throws Exception {
                    AbstractIoUringStreamChannel.shutdownDone(shutdownOutputFuture, shutdownInputFuture, promise);
                }
            });
        }
    }

    private static void shutdownDone(ChannelFuture shutdownOutputFuture, ChannelFuture shutdownInputFuture, ChannelPromise promise) {
        Throwable shutdownOutputCause = shutdownOutputFuture.cause();
        Throwable shutdownInputCause = shutdownInputFuture.cause();
        if (shutdownOutputCause != null) {
            if (shutdownInputCause != null) {
                logger.info("Exception suppressed because a previous exception occurred.", shutdownInputCause);
            }
            promise.setFailure(shutdownOutputCause);
        } else if (shutdownInputCause != null) {
            promise.setFailure(shutdownInputCause);
        } else {
            promise.setSuccess();
        }
    }

    @Override
    protected final void doRegister(ChannelPromise promise) {
        ChannelPromise registerPromise = this.newPromise();
        registerPromise.addListener(f -> {
            if (f.isSuccess()) {
                try {
                    short bgid = ((IoUringStreamChannelConfig)this.config()).getBufferGroupId();
                    if (bgid >= 0) {
                        IoUringIoHandler ioUringIoHandler = (IoUringIoHandler)this.registration().attachment();
                        this.bufferRing = ioUringIoHandler.findBufferRing(bgid);
                    }
                    if (!this.active) return;
                    this.schedulePollRdHup();
                    return;
                }
                finally {
                    promise.setSuccess();
                }
            } else {
                promise.setFailure(f.cause());
            }
        });
        super.doRegister(registerPromise);
    }

    @Override
    protected Object filterOutboundMessage(Object msg) {
        if (IoUring.isSpliceSupported() && msg instanceof DefaultFileRegion) {
            return new IoUringFileRegion((DefaultFileRegion)msg);
        }
        return super.filterOutboundMessage(msg);
    }

    @Override
    protected final void cancelOutstandingReads(IoRegistration registration, int numOutstandingReads) {
        if (this.readId != 0L) {
            assert (numOutstandingReads == 1 || numOutstandingReads == -1);
            IoUringIoOps ops = IoUringIoOps.newAsyncCancel((byte)0, this.readId, this.readOpCode);
            long id = registration.submit((IoOps)ops);
            assert (id != 0L);
            this.readId = 0L;
        }
    }

    @Override
    protected final void cancelOutstandingWrites(IoRegistration registration, int numOutstandingWrites) {
        if (this.writeId != 0L) {
            assert (numOutstandingWrites == 1);
            assert (this.writeOpCode != 0);
            long id = registration.submit((IoOps)IoUringIoOps.newAsyncCancel((byte)0, this.writeId, this.writeOpCode));
            assert (id != 0L);
            this.writeId = 0L;
        }
    }

    @Override
    protected boolean socketIsEmpty(int flags) {
        return IoUring.isCqeFSockNonEmptySupported() && (flags & 4) == 0;
    }

    @Override
    boolean isPollInFirst() {
        return this.bufferRing == null || !this.bufferRing.isUsable();
    }

    protected class IoUringStreamUnsafe
    extends AbstractIoUringChannel.AbstractUringUnsafe {
        private ByteBuf readBuffer;

        protected IoUringStreamUnsafe() {
            super(AbstractIoUringStreamChannel.this);
        }

        @Override
        protected int scheduleWriteMultiple(ChannelOutboundBuffer in) {
            assert (AbstractIoUringStreamChannel.this.writeId == 0L);
            int fd = AbstractIoUringStreamChannel.this.fd().intValue();
            IoRegistration registration = AbstractIoUringStreamChannel.this.registration();
            IoUringIoHandler handler = (IoUringIoHandler)registration.attachment();
            IovArray iovArray = handler.iovArray();
            int offset = iovArray.count();
            try {
                in.forEachFlushedMessage(this.filterWriteMultiple(iovArray));
            }
            catch (Exception e) {
                return this.scheduleWriteSingle(in.current());
            }
            long iovArrayAddress = iovArray.memoryAddress(offset);
            int iovArrayLength = iovArray.count() - offset;
            IoUringIoOps ops = IoUringIoOps.newWritev(fd, (byte)0, 0, iovArrayAddress, iovArrayLength, AbstractIoUringStreamChannel.this.nextOpsId());
            byte opCode = ops.opcode();
            AbstractIoUringStreamChannel.this.writeId = registration.submit((IoOps)ops);
            AbstractIoUringStreamChannel.this.writeOpCode = opCode;
            if (AbstractIoUringStreamChannel.this.writeId == 0L) {
                return 0;
            }
            return 1;
        }

        protected ChannelOutboundBuffer.MessageProcessor filterWriteMultiple(IovArray iovArray) {
            return iovArray;
        }

        @Override
        protected int scheduleWriteSingle(Object msg) {
            IoUringIoOps ops;
            assert (AbstractIoUringStreamChannel.this.writeId == 0L);
            int fd = AbstractIoUringStreamChannel.this.fd().intValue();
            IoRegistration registration = AbstractIoUringStreamChannel.this.registration();
            if (msg instanceof IoUringFileRegion) {
                IoUringFileRegion fileRegion = (IoUringFileRegion)msg;
                try {
                    fileRegion.open();
                }
                catch (IOException e) {
                    this.handleWriteError(e);
                    return 0;
                }
                ops = fileRegion.splice(fd);
            } else {
                ByteBuf buf = (ByteBuf)msg;
                long address = IoUring.memoryAddress(buf) + (long)buf.readerIndex();
                int length = buf.readableBytes();
                short opsid = AbstractIoUringStreamChannel.this.nextOpsId();
                ops = IoUringIoOps.newSend(fd, (byte)0, 0, address, length, opsid);
            }
            byte opCode = ops.opcode();
            AbstractIoUringStreamChannel.this.writeId = registration.submit((IoOps)ops);
            AbstractIoUringStreamChannel.this.writeOpCode = opCode;
            if (AbstractIoUringStreamChannel.this.writeId == 0L) {
                return 0;
            }
            return 1;
        }

        private int calculateRecvFlags(boolean first) {
            if (first) {
                return 0;
            }
            return Native.MSG_DONTWAIT;
        }

        private short calculateRecvIoPrio(boolean first, boolean socketIsEmpty) {
            if (first) {
                return socketIsEmpty && IoUring.isCqeFSockNonEmptySupported() ? (short)1 : 0;
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected int scheduleRead0(boolean first, boolean socketIsEmpty) {
            assert (this.readBuffer == null);
            assert (AbstractIoUringStreamChannel.this.readId == 0L) : AbstractIoUringStreamChannel.this.readId;
            IoUringRecvByteAllocatorHandle allocHandle = this.recvBufAllocHandle();
            if (AbstractIoUringStreamChannel.this.bufferRing != null && AbstractIoUringStreamChannel.this.bufferRing.isUsable()) {
                return this.scheduleReadProviderBuffer(AbstractIoUringStreamChannel.this.bufferRing, first, socketIsEmpty);
            }
            ByteBuf byteBuf = allocHandle.allocate(AbstractIoUringStreamChannel.this.alloc());
            try {
                int fd = AbstractIoUringStreamChannel.this.fd().intValue();
                IoRegistration registration = AbstractIoUringStreamChannel.this.registration();
                short ioPrio = this.calculateRecvIoPrio(first, socketIsEmpty);
                int recvFlags = this.calculateRecvFlags(first);
                IoUringIoOps ops = IoUringIoOps.newRecv(fd, (byte)0, ioPrio, recvFlags, IoUring.memoryAddress(byteBuf) + (long)byteBuf.writerIndex(), byteBuf.writableBytes(), AbstractIoUringStreamChannel.this.nextOpsId());
                AbstractIoUringStreamChannel.this.readId = registration.submit((IoOps)ops);
                AbstractIoUringStreamChannel.this.readOpCode = (byte)27;
                if (AbstractIoUringStreamChannel.this.readId == 0L) {
                    int n = 0;
                    return n;
                }
                this.readBuffer = byteBuf;
                byteBuf = null;
                int n = 1;
                return n;
            }
            finally {
                if (byteBuf != null) {
                    byteBuf.release();
                }
            }
        }

        private int scheduleReadProviderBuffer(IoUringBufferRing bufferRing, boolean first, boolean socketIsEmpty) {
            short bgId = bufferRing.bufferGroupId();
            try {
                int recvFlags;
                short ioPrio;
                boolean multishot = IoUring.isRecvMultishotEnabled();
                byte flags = (byte)Native.IOSQE_BUFFER_SELECT;
                if (multishot) {
                    ioPrio = 2;
                    recvFlags = 0;
                } else {
                    ioPrio = this.calculateRecvIoPrio(first, socketIsEmpty);
                    recvFlags = this.calculateRecvFlags(first);
                }
                if (IoUring.isRecvsendBundleEnabled()) {
                    ioPrio = (short)(ioPrio | 0x10);
                }
                IoRegistration registration = AbstractIoUringStreamChannel.this.registration();
                int fd = AbstractIoUringStreamChannel.this.fd().intValue();
                IoUringIoOps ops = IoUringIoOps.newRecv(fd, flags, ioPrio, recvFlags, 0L, 0, AbstractIoUringStreamChannel.this.nextOpsId(), bgId);
                AbstractIoUringStreamChannel.this.readId = registration.submit((IoOps)ops);
                AbstractIoUringStreamChannel.this.readOpCode = (byte)27;
                if (AbstractIoUringStreamChannel.this.readId == 0L) {
                    return 0;
                }
                if (multishot) {
                    return -1;
                }
                return 1;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.handleReadException(AbstractIoUringStreamChannel.this.pipeline(), null, illegalArgumentException, false, this.recvBufAllocHandle());
                return 0;
            }
        }

        @Override
        protected void readComplete0(byte op, int res, int flags, short data, int outstanding) {
            ByteBuf byteBuf = this.readBuffer;
            this.readBuffer = null;
            if (res == Native.ERRNO_ECANCELED_NEGATIVE) {
                AbstractIoUringStreamChannel.this.readId = 0L;
                if (byteBuf != null) {
                    byteBuf.release();
                }
                return;
            }
            boolean rearm = (flags & 2) == 0;
            boolean useBufferRing = (flags & 1) != 0;
            short bid = (short)(flags >> 16);
            boolean more = (flags & 0x10) != 0;
            boolean empty = AbstractIoUringStreamChannel.this.socketIsEmpty(flags);
            if (rearm) {
                AbstractIoUringStreamChannel.this.readId = 0L;
            }
            boolean allDataRead = false;
            IoUringRecvByteAllocatorHandle allocHandle = this.recvBufAllocHandle();
            ChannelPipeline pipeline = AbstractIoUringStreamChannel.this.pipeline();
            try {
                if (res < 0) {
                    if (res == Native.ERRNO_NOBUFS_NEGATIVE) {
                        if (!AbstractIoUringStreamChannel.this.bufferRing.expand()) {
                            pipeline.fireUserEventTriggered((Object)AbstractIoUringStreamChannel.this.bufferRing.getExhaustedEvent());
                        }
                        this.scheduleRead(allocHandle.isFirstRead());
                        return;
                    }
                    allocHandle.lastBytesRead(Errors.ioResult((String)"io_uring read", (int)res));
                } else if (res > 0) {
                    if (useBufferRing) {
                        int read = res;
                        while (true) {
                            int attemptedBytesRead = AbstractIoUringStreamChannel.this.bufferRing.attemptedBytesRead(bid);
                            byteBuf = AbstractIoUringStreamChannel.this.bufferRing.useBuffer(bid, read, more);
                            allocHandle.attemptedBytesRead(attemptedBytesRead);
                            allocHandle.lastBytesRead(byteBuf.readableBytes());
                            assert ((read -= byteBuf.readableBytes()) >= 0);
                            if (read != 0) {
                                allocHandle.incMessagesRead(1);
                                pipeline.fireChannelRead((Object)byteBuf);
                                byteBuf = null;
                                bid = AbstractIoUringStreamChannel.this.bufferRing.nextBid(bid);
                                if (allocHandle.continueReading()) continue;
                                allocHandle.readComplete();
                                pipeline.fireChannelReadComplete();
                                allocHandle.reset(AbstractIoUringStreamChannel.this.config());
                                continue;
                            }
                            break;
                        }
                    } else {
                        int attemptedBytesRead = byteBuf.writableBytes();
                        byteBuf.writerIndex(byteBuf.writerIndex() + res);
                        allocHandle.attemptedBytesRead(attemptedBytesRead);
                        allocHandle.lastBytesRead(res);
                    }
                } else {
                    allocHandle.lastBytesRead(-1);
                }
                if (allocHandle.lastBytesRead() <= 0) {
                    if (byteBuf != null) {
                        byteBuf.release();
                        byteBuf = null;
                    }
                    boolean bl = allDataRead = allocHandle.lastBytesRead() < 0;
                    if (allDataRead) {
                        this.shutdownInput(true);
                    }
                    allocHandle.readComplete();
                    pipeline.fireChannelReadComplete();
                    return;
                }
                allocHandle.incMessagesRead(1);
                pipeline.fireChannelRead((Object)byteBuf);
                byteBuf = null;
                this.scheduleNextRead(pipeline, allocHandle, rearm, empty);
            }
            catch (Throwable t) {
                this.handleReadException(pipeline, byteBuf, t, allDataRead, allocHandle);
            }
        }

        private void scheduleNextRead(ChannelPipeline pipeline, IoUringRecvByteAllocatorHandle allocHandle, boolean rearm, boolean empty) {
            if (allocHandle.continueReading() && !empty) {
                if (rearm) {
                    this.scheduleRead(false);
                }
            } else {
                allocHandle.readComplete();
                pipeline.fireChannelReadComplete();
            }
        }

        protected final void handleReadException(ChannelPipeline pipeline, ByteBuf byteBuf, Throwable cause, boolean allDataRead, IoUringRecvByteAllocatorHandle allocHandle) {
            if (byteBuf != null) {
                if (byteBuf.isReadable()) {
                    pipeline.fireChannelRead((Object)byteBuf);
                } else {
                    byteBuf.release();
                }
            }
            allocHandle.readComplete();
            pipeline.fireChannelReadComplete();
            pipeline.fireExceptionCaught(cause);
            if (allDataRead || cause instanceof IOException) {
                this.shutdownInput(true);
            }
        }

        private boolean handleWriteCompleteFileRegion(ChannelOutboundBuffer channelOutboundBuffer, IoUringFileRegion fileRegion, int res, short data) {
            try {
                int result;
                if (res == Native.ERRNO_ECANCELED_NEGATIVE) {
                    return true;
                }
                int n = result = res >= 0 ? res : Errors.ioResult((String)"io_uring splice", (int)res);
                if (result == 0 && fileRegion.count() > 0L) {
                    AbstractIoUringStreamChannel.this.validateFileRegion(fileRegion.fileRegion, fileRegion.transfered());
                    return false;
                }
                int progress = fileRegion.handleResult(result, data);
                if (progress == -1) {
                    channelOutboundBuffer.remove();
                } else if (progress > 0) {
                    channelOutboundBuffer.progress((long)progress);
                }
            }
            catch (Throwable cause) {
                this.handleWriteError(cause);
            }
            return true;
        }

        @Override
        boolean writeComplete0(byte op, int res, int flags, short data, int outstanding) {
            ChannelOutboundBuffer channelOutboundBuffer;
            Object current;
            if ((flags & 8) == 0) {
                AbstractIoUringStreamChannel.this.writeId = 0L;
                AbstractIoUringStreamChannel.this.writeOpCode = 0;
            }
            if ((current = (channelOutboundBuffer = AbstractIoUringStreamChannel.this.unsafe().outboundBuffer()).current()) instanceof IoUringFileRegion) {
                IoUringFileRegion fileRegion = (IoUringFileRegion)current;
                return this.handleWriteCompleteFileRegion(channelOutboundBuffer, fileRegion, res, data);
            }
            if (res >= 0) {
                channelOutboundBuffer.removeBytes((long)res);
            } else {
                if (res == Native.ERRNO_ECANCELED_NEGATIVE) {
                    return true;
                }
                try {
                    if (Errors.ioResult((String)"io_uring write", (int)res) == 0) {
                        return false;
                    }
                }
                catch (Throwable cause) {
                    this.handleWriteError(cause);
                }
            }
            return true;
        }

        @Override
        public void unregistered() {
            super.unregistered();
            assert (this.readBuffer == null);
        }
    }
}

