/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.uring;

import io.netty.channel.uring.IoUring;
import io.netty.channel.uring.IoUringBufferRingAllocator;
import io.netty.util.internal.ObjectUtil;
import java.util.Objects;

public final class IoUringBufferRingConfig {
    private final short bgId;
    private final short bufferRingSize;
    private final int maxUnreleasedBuffers;
    private final boolean incremental;
    private final IoUringBufferRingAllocator allocator;

    public IoUringBufferRingConfig(short bgId, short bufferRingSize, int maxUnreleasedBuffers, IoUringBufferRingAllocator allocator) {
        this(bgId, bufferRingSize, maxUnreleasedBuffers, IoUring.isRegisterBufferRingIncSupported(), allocator);
    }

    public IoUringBufferRingConfig(short bgId, short bufferRingSize, int maxUnreleasedBuffers, boolean incremental, IoUringBufferRingAllocator allocator) {
        this.bgId = (short)ObjectUtil.checkPositiveOrZero((int)bgId, (String)"bgId");
        this.bufferRingSize = IoUringBufferRingConfig.checkBufferRingSize(bufferRingSize);
        this.maxUnreleasedBuffers = ObjectUtil.checkInRange((int)maxUnreleasedBuffers, (int)bufferRingSize, (int)Integer.MAX_VALUE, (String)"maxUnreleasedBuffers");
        if (incremental && !IoUring.isRegisterBufferRingIncSupported()) {
            throw new IllegalArgumentException("Incremental buffer ring is not supported");
        }
        this.incremental = incremental;
        this.allocator = (IoUringBufferRingAllocator)ObjectUtil.checkNotNull((Object)allocator, (String)"allocator");
    }

    public short bufferGroupId() {
        return this.bgId;
    }

    public short bufferRingSize() {
        return this.bufferRingSize;
    }

    public int maxUnreleasedBuffers() {
        return this.maxUnreleasedBuffers;
    }

    public IoUringBufferRingAllocator allocator() {
        return this.allocator;
    }

    public boolean isIncremental() {
        return this.incremental;
    }

    private static short checkBufferRingSize(short bufferRingSize) {
        boolean isPowerOfTwo;
        if (bufferRingSize < 1) {
            throw new IllegalArgumentException("bufferRingSize: " + bufferRingSize + " (expected: > 0)");
        }
        boolean bl = isPowerOfTwo = (bufferRingSize & bufferRingSize - 1) == 0;
        if (!isPowerOfTwo) {
            throw new IllegalArgumentException("bufferRingSize: " + bufferRingSize + " (expected: power of 2)");
        }
        return bufferRingSize;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IoUringBufferRingConfig that = (IoUringBufferRingConfig)o;
        return this.bgId == that.bgId;
    }

    public int hashCode() {
        return Objects.hashCode(this.bgId);
    }
}

