/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.uring;

import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.uring.IoUringChannelOption;
import java.util.Map;

abstract class IoUringStreamChannelConfig
extends DefaultChannelConfig {
    private volatile boolean useIoUringBufferGroup;

    IoUringStreamChannelConfig(Channel channel) {
        super(channel);
    }

    IoUringStreamChannelConfig(Channel channel, RecvByteBufAllocator allocator) {
        super(channel, allocator);
    }

    public <T> T getOption(ChannelOption<T> option) {
        if (option == IoUringChannelOption.USE_IO_URING_BUFFER_GROUP) {
            return (T)Boolean.valueOf(this.getUseIoUringBufferGroup());
        }
        return (T)super.getOption(option);
    }

    public <T> boolean setOption(ChannelOption<T> option, T value) {
        if (option == IoUringChannelOption.USE_IO_URING_BUFFER_GROUP) {
            this.setUseIoUringBufferGroup((Boolean)value);
            return true;
        }
        return super.setOption(option, value);
    }

    public Map<ChannelOption<?>, Object> getOptions() {
        return this.getOptions(super.getOptions(), new ChannelOption[]{IoUringChannelOption.USE_IO_URING_BUFFER_GROUP});
    }

    boolean getUseIoUringBufferGroup() {
        return this.useIoUringBufferGroup;
    }

    IoUringStreamChannelConfig setUseIoUringBufferGroup(boolean useIoUringBufferGroup) {
        this.useIoUringBufferGroup = useIoUringBufferGroup;
        return this;
    }
}

