/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.uring;

import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.ServerSocketChannelConfig;
import io.netty.channel.uring.AbstractIoUringServerChannel;
import io.netty.channel.uring.IoUring;
import io.netty.channel.uring.IoUringIoHandler;
import io.netty.channel.uring.IoUringServerSocketChannelConfig;
import io.netty.channel.uring.IoUringSocketChannel;
import io.netty.channel.uring.LinuxSocket;
import io.netty.channel.uring.SockaddrIn;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public final class IoUringServerSocketChannel
extends AbstractIoUringServerChannel
implements ServerSocketChannel {
    private final IoUringServerSocketChannelConfig config = new IoUringServerSocketChannelConfig(this);

    public IoUringServerSocketChannel() {
        super(LinuxSocket.newSocketStream(), false);
    }

    public ServerSocketChannelConfig config() {
        return this.config;
    }

    @Override
    Channel newChildChannel(int fd, long acceptedAddressMemoryAddress, long acceptedAddressLengthMemoryAddress) {
        InetSocketAddress address;
        IoUringIoHandler handler = (IoUringIoHandler)this.registration().attachment();
        if (this.socket.isIpv6()) {
            byte[] ipv6Array = handler.inet6AddressArray();
            byte[] ipv4Array = handler.inet4AddressArray();
            address = SockaddrIn.readIPv6(acceptedAddressMemoryAddress, ipv6Array, ipv4Array);
        } else {
            byte[] addressArray = handler.inet4AddressArray();
            address = SockaddrIn.readIPv4(acceptedAddressMemoryAddress, addressArray);
        }
        return new IoUringSocketChannel((Channel)this, new LinuxSocket(fd), address);
    }

    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    public void doBind(SocketAddress localAddress) throws Exception {
        Integer fastOpen;
        super.doBind(localAddress);
        if (IoUring.isTcpFastOpenServerSideAvailable() && (fastOpen = (Integer)this.config().getOption(ChannelOption.TCP_FASTOPEN)) != null && fastOpen > 0) {
            this.socket.setTcpFastOpen(fastOpen);
        }
        this.socket.listen(this.config.getBacklog());
        this.active = true;
    }
}

