/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.uring;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.uring.IoUringBufferRingExhaustedEvent;
import io.netty.channel.uring.IoUringIoHandler;
import io.netty.channel.uring.Native;
import io.netty.util.internal.PlatformDependent;
import java.util.Arrays;

final class IoUringBufferRing {
    private final long ioUringBufRingAddr;
    private final short entries;
    private final short mask;
    private final short bufferGroupId;
    private final int ringFd;
    private final ByteBuf[] buffers;
    private final int chunkSize;
    private final IoUringIoHandler source;
    private final ByteBufAllocator byteBufAllocator;
    private final IoUringBufferRingExhaustedEvent exhaustedEvent;
    private final boolean incremental;
    private boolean hasSpareBuffer;
    private short tail;
    private int numBuffers;

    IoUringBufferRing(int ringFd, long ioUringBufRingAddr, short entries, short bufferGroupId, int chunkSize, boolean incremental, IoUringIoHandler ioUringIoHandler, ByteBufAllocator byteBufAllocator) {
        assert (entries % 2 == 0);
        this.ioUringBufRingAddr = ioUringBufRingAddr;
        this.entries = entries;
        this.mask = (short)(entries - 1);
        this.bufferGroupId = bufferGroupId;
        this.ringFd = ringFd;
        this.buffers = new ByteBuf[entries];
        this.chunkSize = chunkSize;
        this.incremental = incremental;
        this.source = ioUringIoHandler;
        this.byteBufAllocator = byteBufAllocator;
        this.exhaustedEvent = new IoUringBufferRingExhaustedEvent(bufferGroupId);
    }

    void refillIfNecessary() {
        if (!this.hasSpareBuffer) {
            this.refill();
        }
    }

    void markExhausted() {
        this.hasSpareBuffer = false;
        this.source.idHandler.notifyAllBuffersUsed(this.bufferGroupId);
    }

    IoUringBufferRingExhaustedEvent getExhaustedEvent() {
        return this.exhaustedEvent;
    }

    private short idx(short idx) {
        return (short)(idx & this.mask);
    }

    private void refill() {
        long tailFieldAddress = this.ioUringBufRingAddr + (long)Native.IO_URING_BUFFER_RING_TAIL;
        short oldTail = PlatformDependent.getShort((long)tailFieldAddress);
        int num = this.entries - this.numBuffers;
        for (int i = 0; i < num; i = (int)((short)(i + 1))) {
            short s = this.tail;
            this.tail = (short)(s + 1);
            short bid = this.idx(s);
            assert (this.buffers[bid] == null) : "buffer[" + bid + "] is already used";
            ByteBuf byteBuf = this.byteBufAllocator.directBuffer(this.chunkSize);
            byteBuf.writerIndex(byteBuf.capacity());
            this.buffers[bid] = byteBuf;
            int ringIndex = oldTail + i & this.mask;
            long ioUringBufAddress = this.ioUringBufRingAddr + (long)Native.SIZEOF_IOURING_BUF * (long)ringIndex;
            PlatformDependent.putLong((long)(ioUringBufAddress + (long)Native.IOURING_BUFFER_OFFSETOF_ADDR), (long)(byteBuf.memoryAddress() + (long)byteBuf.readerIndex()));
            PlatformDependent.putInt((long)(ioUringBufAddress + (long)Native.IOURING_BUFFER_OFFSETOF_LEN), (int)byteBuf.capacity());
            PlatformDependent.putShort((long)(ioUringBufAddress + (long)Native.IOURING_BUFFER_OFFSETOF_BID), (short)bid);
            ++this.numBuffers;
        }
        PlatformDependent.putShortOrdered((long)tailFieldAddress, (short)((short)(oldTail + this.entries)));
        this.hasSpareBuffer = true;
        this.source.idHandler.notifyMoreBuffersReady(this.bufferGroupId);
    }

    ByteBuf useBuffer(short bid, int readableBytes, boolean more) {
        ByteBuf byteBuf = this.buffers[bid];
        if (this.incremental && more) {
            return byteBuf.readRetainedSlice(readableBytes);
        }
        this.buffers[bid] = null;
        --this.numBuffers;
        return byteBuf.writerIndex(byteBuf.readerIndex() + readableBytes);
    }

    short bufferGroupId() {
        return this.bufferGroupId;
    }

    int chunkSize() {
        return this.chunkSize;
    }

    void close() {
        Native.ioUringUnRegisterBufRing(this.ringFd, this.ioUringBufRingAddr, this.entries, this.bufferGroupId);
        for (ByteBuf byteBuf : this.buffers) {
            if (byteBuf == null) continue;
            byteBuf.release();
        }
        Arrays.fill(this.buffers, null);
    }
}

