/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.uring;

import io.netty.channel.uring.Iov;
import io.netty.channel.uring.Native;
import io.netty.channel.uring.UserData;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.StringJoiner;
import java.util.function.IntSupplier;

final class SubmissionQueue {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SubmissionQueue.class);
    private static final long SQE_SIZE = 64L;
    private static final int INT_SIZE = 4;
    private static final int KERNEL_TIMESPEC_SIZE = 16;
    private static final int SQE_OP_CODE_FIELD = 0;
    private static final int SQE_FLAGS_FIELD = 1;
    private static final int SQE_IOPRIO_FIELD = 2;
    private static final int SQE_FD_FIELD = 4;
    private static final int SQE_UNION1_FIELD = 8;
    private static final int SQE_UNION2_FIELD = 16;
    private static final int SQE_LEN_FIELD = 24;
    private static final int SQE_UNION3_FIELD = 28;
    private static final int SQE_USER_DATA_FIELD = 32;
    private static final int SQE_UNION4_FIELD = 40;
    private static final int SQE_PERSONALITY_FIELD = 42;
    private static final int SQE_UNION5_FIELD = 44;
    private static final int SQE_UNION6_FIELD = 48;
    private static final int KERNEL_TIMESPEC_TV_SEC_FIELD = 0;
    private static final int KERNEL_TIMESPEC_TV_NSEC_FIELD = 8;
    private final long kHeadAddress;
    private final long kTailAddress;
    private final long kFlagsAddress;
    private final long kDroppedAddress;
    private final long kArrayAddress;
    final long submissionQueueArrayAddress;
    final int ringEntries;
    private final int ringMask;
    final int ringSize;
    final long ringAddress;
    final int ringFd;
    private final long timeoutMemoryAddress;
    private final IntSupplier completionCount;
    private int numHandledFds;
    private int head;
    private int tail;

    SubmissionQueue(long kHeadAddress, long kTailAddress, long kRingMaskAddress, long kRingEntriesAddress, long kFlagsAddress, long kDroppedAddress, long kArrayAddress, long submissionQueueArrayAddress, int ringSize, long ringAddress, int ringFd, IntSupplier completionCount) {
        this.kHeadAddress = kHeadAddress;
        this.kTailAddress = kTailAddress;
        this.kFlagsAddress = kFlagsAddress;
        this.kDroppedAddress = kDroppedAddress;
        this.kArrayAddress = kArrayAddress;
        this.submissionQueueArrayAddress = submissionQueueArrayAddress;
        this.ringSize = ringSize;
        this.ringAddress = ringAddress;
        this.ringFd = ringFd;
        this.ringEntries = PlatformDependent.getIntVolatile((long)kRingEntriesAddress);
        this.ringMask = PlatformDependent.getIntVolatile((long)kRingMaskAddress);
        this.head = PlatformDependent.getIntVolatile((long)kHeadAddress);
        this.tail = PlatformDependent.getIntVolatile((long)kTailAddress);
        this.timeoutMemoryAddress = PlatformDependent.allocateMemory((long)16L);
        this.completionCount = completionCount;
        PlatformDependent.setMemory((long)submissionQueueArrayAddress, (long)((long)this.ringEntries * 64L), (byte)0);
        long address = kArrayAddress;
        int i = 0;
        while (i < this.ringEntries) {
            PlatformDependent.putInt((long)address, (int)i);
            ++i;
            address += 4L;
        }
    }

    void incrementHandledFds() {
        ++this.numHandledFds;
    }

    void decrementHandledFds() {
        --this.numHandledFds;
        assert (this.numHandledFds >= 0);
    }

    private long enqueueSqe0(int id, byte opcode, byte flags, short ioPrio, int fd, long union1, long union2, int len, int union3, short data, short union4, short personality, int union5, long union6) {
        int submitted;
        int pending = this.tail - this.head;
        if (pending == this.ringEntries && (submitted = this.submit()) == 0) {
            throw new RuntimeException("SQ ring full and no submissions accepted");
        }
        long sqe = this.submissionQueueArrayAddress + (long)(this.tail++ & this.ringMask) * 64L;
        long udata = UserData.encode(id, opcode, data);
        this.setData(sqe, opcode, flags, ioPrio, fd, union1, union2, len, union3, udata, union4, personality, union5, union6);
        return udata;
    }

    void enqueueSqe(byte opcode, byte flags, short ioPrio, int fd, long union1, long union2, int len, int union3, long udata, short union4, short personality, int union5, long union6) {
        int submitted;
        int pending = this.tail - this.head;
        if (pending == this.ringEntries && (submitted = this.submit()) == 0) {
            throw new RuntimeException("SQ ring full and no submissions accepted");
        }
        long sqe = this.submissionQueueArrayAddress + (long)(this.tail++ & this.ringMask) * 64L;
        this.setData(sqe, opcode, flags, ioPrio, fd, union1, union2, len, union3, udata, union4, personality, union5, union6);
    }

    private void setData(long sqe, byte opcode, byte flags, short ioPrio, int fd, long union1, long union2, int len, int union3, long udata, short union4, short personality, int union5, long union6) {
        PlatformDependent.putByte((long)(sqe + 0L), (byte)opcode);
        PlatformDependent.putByte((long)(sqe + 1L), (byte)flags);
        PlatformDependent.putShort((long)(sqe + 2L), (short)ioPrio);
        PlatformDependent.putInt((long)(sqe + 4L), (int)fd);
        PlatformDependent.putLong((long)(sqe + 8L), (long)union1);
        PlatformDependent.putLong((long)(sqe + 16L), (long)union2);
        PlatformDependent.putInt((long)(sqe + 24L), (int)len);
        PlatformDependent.putInt((long)(sqe + 28L), (int)union3);
        PlatformDependent.putLong((long)(sqe + 32L), (long)udata);
        PlatformDependent.putShort((long)(sqe + 40L), (short)union4);
        PlatformDependent.putShort((long)(sqe + 42L), (short)personality);
        PlatformDependent.putInt((long)(sqe + 44L), (int)union5);
        PlatformDependent.putLong((long)(sqe + 48L), (long)union6);
        if (logger.isTraceEnabled()) {
            if (opcode == 2 || opcode == 1) {
                logger.trace("add(ring {}): {}(fd={}, len={} ({} bytes), off={}, data={})", new Object[]{this.ringFd, Native.opToStr(opcode), fd, len, Iov.sumSize(union2, len), union1, udata});
            } else {
                logger.trace("add(ring {}): {}(fd={}, len={}, off={}, data={})", new Object[]{this.ringFd, Native.opToStr(opcode), fd, len, union1, udata});
            }
        }
    }

    public String toString() {
        StringJoiner sb = new StringJoiner(", ", "SubmissionQueue [", "]");
        int pending = this.tail - this.head;
        for (int i = 0; i < pending; ++i) {
            long sqe = this.submissionQueueArrayAddress + (long)(this.head + i & this.ringMask) * 64L;
            sb.add(Native.opToStr(PlatformDependent.getByte((long)(sqe + 0L))) + "(fd=" + PlatformDependent.getInt((long)(sqe + 4L)) + ')');
        }
        return sb.toString();
    }

    long addNop(int fd, byte flags, int id, short data) {
        return this.enqueueSqe0(id, (byte)0, flags, (short)0, fd, 0L, 0L, 0, 0, data, (short)0, (short)0, 0, 0L);
    }

    long addTimeout(int fd, long nanoSeconds, int id, short extraData) {
        this.setTimeout(nanoSeconds);
        return this.enqueueSqe0(id, (byte)11, (byte)0, (short)0, fd, 0L, this.timeoutMemoryAddress, 1, 0, extraData, (short)0, (short)0, 0, 0L);
    }

    long addLinkTimeout(int fd, long nanoSeconds, int id, short extraData) {
        this.setTimeout(nanoSeconds);
        return this.enqueueSqe0(id, (byte)15, (byte)0, (short)0, fd, 0L, this.timeoutMemoryAddress, 1, 0, extraData, (short)0, (short)0, 0, 0L);
    }

    long addEventFdRead(int fd, long bufferAddress, int pos, int limit, int id, short extraData) {
        return this.enqueueSqe0(id, (byte)22, (byte)0, (short)0, fd, 0L, bufferAddress + (long)pos, limit - pos, 0, extraData, (short)0, (short)0, 0, 0L);
    }

    long addCancel(int fd, long sqeToCancel, int id) {
        return this.enqueueSqe0(id, (byte)14, (byte)0, (short)0, fd, 0L, sqeToCancel, 0, 0, (short)0, (short)0, (short)0, 0, 0L);
    }

    int submit() {
        int submit = this.tail - this.head;
        return submit > 0 ? this.submit(submit, 0, 0) : 0;
    }

    int submitAndWait() {
        int submit = this.tail - this.head;
        if (submit > 0) {
            return this.submit(submit, 1, Native.IORING_ENTER_GETEVENTS);
        }
        assert (submit == 0);
        int ret = Native.ioUringEnter(this.ringFd, 0, 1, Native.IORING_ENTER_GETEVENTS);
        if (ret < 0) {
            throw new RuntimeException("ioUringEnter syscall returned " + ret);
        }
        return ret;
    }

    private int submit(int toSubmit, int minComplete, int flags) {
        if (logger.isTraceEnabled()) {
            logger.trace("submit(ring {}): {}", (Object)this.ringFd, (Object)this.toString());
        }
        PlatformDependent.putIntOrdered((long)this.kTailAddress, (int)this.tail);
        int ret = Native.ioUringEnter(this.ringFd, toSubmit, minComplete, flags);
        this.head = PlatformDependent.getIntVolatile((long)this.kHeadAddress);
        if (ret != toSubmit) {
            if (ret < 0) {
                throw new RuntimeException("ioUringEnter syscall returned " + ret);
            }
            logger.warn("Not all submissions succeeded. Only {} of {} SQEs were submitted, while there are {} pending completions.", new Object[]{ret, toSubmit, this.completionCount.getAsInt()});
        }
        return ret;
    }

    private void setTimeout(long timeoutNanoSeconds) {
        long nanoSeconds;
        long seconds;
        if (timeoutNanoSeconds == 0L) {
            seconds = 0L;
            nanoSeconds = 0L;
        } else {
            seconds = (int)Math.min(timeoutNanoSeconds / 1000000000L, Integer.MAX_VALUE);
            nanoSeconds = (int)Math.max(timeoutNanoSeconds - seconds * 1000000000L, 0L);
        }
        PlatformDependent.putLong((long)(this.timeoutMemoryAddress + 0L), (long)seconds);
        PlatformDependent.putLong((long)(this.timeoutMemoryAddress + 8L), (long)nanoSeconds);
    }

    public int count() {
        return this.tail - this.head;
    }

    public int remaining() {
        return this.ringEntries - this.count();
    }

    public void release() {
        PlatformDependent.freeMemory((long)this.timeoutMemoryAddress);
    }
}

