/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.uring;

import io.netty.channel.Channel;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.ServerChannel;
import io.netty.channel.unix.Buffer;
import io.netty.channel.unix.Errors;
import io.netty.channel.uring.AbstractIoUringChannel;
import io.netty.channel.uring.IoUringIoOps;
import io.netty.channel.uring.IoUringIoRegistration;
import io.netty.channel.uring.IoUringRecvByteAllocatorHandle;
import io.netty.channel.uring.LinuxSocket;
import io.netty.channel.uring.Native;
import java.net.SocketAddress;
import java.nio.ByteBuffer;

abstract class AbstractIoUringServerChannel
extends AbstractIoUringChannel
implements ServerChannel {
    private static final ChannelMetadata METADATA = new ChannelMetadata(false, 16);
    private final ByteBuffer acceptedAddressMemory = Buffer.allocateDirectWithNativeOrder((int)Native.SIZEOF_SOCKADDR_STORAGE);
    private final ByteBuffer acceptedAddressLengthMemory;
    private final long acceptedAddressMemoryAddress = Buffer.memoryAddress((ByteBuffer)this.acceptedAddressMemory);
    private final long acceptedAddressLengthMemoryAddress;
    private long acceptId;

    protected AbstractIoUringServerChannel(LinuxSocket socket, boolean active) {
        super(null, socket, active);
        this.acceptedAddressLengthMemory = Buffer.allocateDirectWithNativeOrder((int)8);
        this.acceptedAddressLengthMemory.putLong(0, Native.SIZEOF_SOCKADDR_STORAGE);
        this.acceptedAddressLengthMemoryAddress = Buffer.memoryAddress((ByteBuffer)this.acceptedAddressLengthMemory);
    }

    public final ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    protected final void doClose() throws Exception {
        super.doClose();
    }

    protected final AbstractIoUringChannel.AbstractUringUnsafe newUnsafe() {
        return new UringServerChannelUnsafe();
    }

    @Override
    protected final void doWrite(ChannelOutboundBuffer in) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected final void cancelOutstandingReads(IoUringIoRegistration registration, int numOutstandingReads) {
        if (this.acceptId != 0L) {
            assert (numOutstandingReads == 1);
            int fd = this.fd().intValue();
            IoUringIoOps ops = IoUringIoOps.newAsyncCancel(fd, (byte)0, this.acceptId, (short)13);
            registration.submit(ops);
        } else assert (numOutstandingReads == 0);
    }

    @Override
    protected final void cancelOutstandingWrites(IoUringIoRegistration registration, int numOutstandingWrites) {
        assert (numOutstandingWrites == 0);
    }

    abstract Channel newChildChannel(int var1, long var2, long var4) throws Exception;

    private final class UringServerChannelUnsafe
    extends AbstractIoUringChannel.AbstractUringUnsafe {
        private UringServerChannelUnsafe() {
            super(AbstractIoUringServerChannel.this);
        }

        @Override
        protected int scheduleWriteMultiple(ChannelOutboundBuffer in) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected int scheduleWriteSingle(Object msg) {
            throw new UnsupportedOperationException();
        }

        @Override
        boolean writeComplete0(byte op, int res, int flags, short data, int outstanding) {
            throw new UnsupportedOperationException();
        }

        @Override
        protected int scheduleRead0(boolean first) {
            assert (AbstractIoUringServerChannel.this.acceptId == 0L);
            IoUringRecvByteAllocatorHandle allocHandle = this.recvBufAllocHandle();
            allocHandle.attemptedBytesRead(1);
            int fd = AbstractIoUringServerChannel.this.fd().intValue();
            IoUringIoRegistration registration = AbstractIoUringServerChannel.this.registration();
            IoUringIoOps ops = IoUringIoOps.newAccept(fd, (byte)0, 0, AbstractIoUringServerChannel.this.acceptedAddressMemoryAddress, AbstractIoUringServerChannel.this.acceptedAddressLengthMemoryAddress, AbstractIoUringServerChannel.this.nextOpsId());
            AbstractIoUringServerChannel.this.acceptId = registration.submit(ops);
            if (AbstractIoUringServerChannel.this.acceptId == 0L) {
                return 0;
            }
            return 1;
        }

        @Override
        protected void readComplete0(byte op, int res, int flags, short data, int outstanding) {
            block8: {
                assert (AbstractIoUringServerChannel.this.acceptId != 0L);
                AbstractIoUringServerChannel.this.acceptId = 0L;
                IoUringRecvByteAllocatorHandle allocHandle = (IoUringRecvByteAllocatorHandle)AbstractIoUringServerChannel.this.unsafe().recvBufAllocHandle();
                ChannelPipeline pipeline = AbstractIoUringServerChannel.this.pipeline();
                allocHandle.lastBytesRead(res);
                if (res >= 0) {
                    allocHandle.incMessagesRead(1);
                    try {
                        Channel channel = AbstractIoUringServerChannel.this.newChildChannel(res, AbstractIoUringServerChannel.this.acceptedAddressMemoryAddress, AbstractIoUringServerChannel.this.acceptedAddressLengthMemoryAddress);
                        pipeline.fireChannelRead((Object)channel);
                        if (allocHandle.continueReading()) {
                            this.scheduleRead(false);
                            break block8;
                        }
                        allocHandle.readComplete();
                        pipeline.fireChannelReadComplete();
                    }
                    catch (Throwable cause) {
                        allocHandle.readComplete();
                        pipeline.fireChannelReadComplete();
                        pipeline.fireExceptionCaught(cause);
                    }
                } else if (res != Native.ERRNO_ECANCELED_NEGATIVE) {
                    allocHandle.readComplete();
                    pipeline.fireChannelReadComplete();
                    if (res != Errors.ERRNO_EAGAIN_NEGATIVE && res != Errors.ERRNO_EWOULDBLOCK_NEGATIVE) {
                        pipeline.fireExceptionCaught((Throwable)Errors.newIOException((String)"io_uring accept", (int)res));
                    }
                }
            }
        }

        @Override
        public void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            promise.setFailure((Throwable)new UnsupportedOperationException());
        }

        @Override
        protected void freeResourcesNow(IoUringIoRegistration reg) {
            super.freeResourcesNow(reg);
            Buffer.free((ByteBuffer)AbstractIoUringServerChannel.this.acceptedAddressMemory);
            Buffer.free((ByteBuffer)AbstractIoUringServerChannel.this.acceptedAddressLengthMemory);
        }
    }
}

