/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.uring;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelConfig;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.unix.PreferredDirectByteBufAllocator;
import io.netty.util.UncheckedBooleanSupplier;

final class IoUringRecvByteAllocatorHandle
extends RecvByteBufAllocator.DelegatingHandle
implements RecvByteBufAllocator.ExtendedHandle {
    private final PreferredDirectByteBufAllocator preferredDirectByteBufAllocator = new PreferredDirectByteBufAllocator();
    private boolean rdHupReceived;
    private boolean readComplete;

    IoUringRecvByteAllocatorHandle(RecvByteBufAllocator.ExtendedHandle handle) {
        super((RecvByteBufAllocator.Handle)handle);
    }

    public void reset(ChannelConfig config) {
        super.reset(config);
        this.readComplete = false;
    }

    void rdHupReceived() {
        this.rdHupReceived = true;
    }

    public ByteBuf allocate(ByteBufAllocator alloc) {
        this.preferredDirectByteBufAllocator.updateAllocator(alloc);
        return this.delegate().allocate((ByteBufAllocator)this.preferredDirectByteBufAllocator);
    }

    public boolean continueReading() {
        return super.continueReading() || this.rdHupReceived;
    }

    public boolean continueReading(UncheckedBooleanSupplier maybeMoreDataSupplier) {
        return ((RecvByteBufAllocator.ExtendedHandle)this.delegate()).continueReading(maybeMoreDataSupplier) || this.rdHupReceived;
    }

    public void readComplete() {
        super.readComplete();
        this.readComplete = true;
    }

    boolean isReadComplete() {
        return this.readComplete;
    }
}

