/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslContext;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.pkitesting.CertificateBuilder;
import io.netty.pkitesting.X509Bundle;
import io.netty.testsuite.transport.AbstractComboTestsuiteTest;
import io.netty.testsuite.transport.TestsuitePermutation;
import io.netty.testsuite.transport.socket.AbstractSocketTest;
import io.netty.testsuite.util.TestUtils;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLEngine;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class SocketSslEchoTest
extends AbstractSocketTest {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SocketSslEchoTest.class);
    private static final int FIRST_MESSAGE_SIZE = 16384;
    private static final Random random = new Random();
    private static final File CERT_FILE;
    private static final File KEY_FILE;
    static final byte[] data;
    private final AtomicReference<Throwable> clientException = new AtomicReference();
    private final AtomicReference<Throwable> serverException = new AtomicReference();
    private final AtomicInteger clientSendCounter = new AtomicInteger();
    private final AtomicInteger clientRecvCounter = new AtomicInteger();
    private final AtomicInteger serverRecvCounter = new AtomicInteger();
    private final AtomicInteger clientNegoCounter = new AtomicInteger();
    private final AtomicInteger serverNegoCounter = new AtomicInteger();
    private volatile Channel clientChannel;
    private volatile Channel serverChannel;
    private volatile SslHandler clientSslHandler;
    private volatile SslHandler serverSslHandler;
    private final EchoClientHandler clientHandler = new EchoClientHandler(this.clientRecvCounter, this.clientNegoCounter, this.clientException);
    private final EchoServerHandler serverHandler = new EchoServerHandler(this.serverRecvCounter, this.serverNegoCounter, this.serverException);
    private SslContext serverCtx;
    private SslContext clientCtx;
    private Renegotiation renegotiation;
    private boolean serverUsesDelegatedTaskExecutor;
    private boolean clientUsesDelegatedTaskExecutor;
    private boolean autoRead;
    private boolean useChunkedWriteHandler;
    private boolean useCompositeByteBuf;

    public static Collection<Object[]> data() throws Exception {
        ArrayList<SslContext> serverContexts = new ArrayList<SslContext>();
        serverContexts.add(SslContextBuilder.forServer((File)CERT_FILE, (File)KEY_FILE).sslProvider(SslProvider.JDK).protocols(new String[]{"TLSv1.2"}).build());
        ArrayList<SslContext> clientContexts = new ArrayList<SslContext>();
        clientContexts.add(SslContextBuilder.forClient().sslProvider(SslProvider.JDK).trustManager(CERT_FILE).protocols(new String[]{"TLSv1.2"}).endpointIdentificationAlgorithm(null).build());
        boolean hasOpenSsl = OpenSsl.isAvailable();
        if (hasOpenSsl) {
            serverContexts.add(SslContextBuilder.forServer((File)CERT_FILE, (File)KEY_FILE).sslProvider(SslProvider.OPENSSL).protocols(new String[]{"TLSv1.2"}).build());
            clientContexts.add(SslContextBuilder.forClient().sslProvider(SslProvider.OPENSSL).trustManager(CERT_FILE).protocols(new String[]{"TLSv1.2"}).endpointIdentificationAlgorithm(null).build());
        } else {
            logger.warn("OpenSSL is unavailable and thus will not be tested.", OpenSsl.unavailabilityCause());
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (SslContext sc : serverContexts) {
            for (SslContext cc : clientContexts) {
                for (RenegotiationType rt : RenegotiationType.values()) {
                    Renegotiation r;
                    if (rt != RenegotiationType.NONE && (sc instanceof OpenSslContext || cc instanceof OpenSslContext)) continue;
                    switch (rt) {
                        case NONE: {
                            r = Renegotiation.NONE;
                            break;
                        }
                        case SERVER_INITIATED: {
                            r = new Renegotiation(rt, (String)sc.cipherSuites().get(sc.cipherSuites().size() - 1));
                            break;
                        }
                        case CLIENT_INITIATED: {
                            r = new Renegotiation(rt, (String)cc.cipherSuites().get(cc.cipherSuites().size() - 1));
                            break;
                        }
                        default: {
                            throw new Error("Unexpected renegotiation type: " + (Object)((Object)rt));
                        }
                    }
                    for (int i = 0; i < 32; ++i) {
                        params.add(new Object[]{sc, cc, r, (i & 0x10) != 0, (i & 8) != 0, (i & 4) != 0, (i & 2) != 0, (i & 1) != 0});
                    }
                }
            }
        }
        return params;
    }

    @AfterAll
    public static void compressHeapDumps() throws Exception {
        TestUtils.compressHeapDumps();
    }

    @ParameterizedTest(name="{index}: serverEngine = {0}, clientEngine = {1}, renegotiation = {2}, serverUsesDelegatedTaskExecutor = {3}, clientUsesDelegatedTaskExecutor = {4}, autoRead = {5}, useChunkedWriteHandler = {6}, useCompositeByteBuf = {7}")
    @MethodSource(value={"data"})
    @Timeout(value=30000L, unit=TimeUnit.MILLISECONDS)
    public void testSslEcho(SslContext serverCtx, SslContext clientCtx, Renegotiation renegotiation, boolean serverUsesDelegatedTaskExecutor, boolean clientUsesDelegatedTaskExecutor, boolean autoRead, boolean useChunkedWriteHandler, boolean useCompositeByteBuf, TestInfo testInfo) throws Throwable {
        this.serverCtx = serverCtx;
        this.clientCtx = clientCtx;
        this.serverUsesDelegatedTaskExecutor = serverUsesDelegatedTaskExecutor;
        this.clientUsesDelegatedTaskExecutor = clientUsesDelegatedTaskExecutor;
        this.renegotiation = renegotiation;
        this.autoRead = autoRead;
        this.useChunkedWriteHandler = useChunkedWriteHandler;
        this.useCompositeByteBuf = useCompositeByteBuf;
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<ServerBootstrap, Bootstrap>(){

            @Override
            public void run(ServerBootstrap serverBootstrap, Bootstrap bootstrap) throws Throwable {
                SocketSslEchoTest.this.testSslEcho(serverBootstrap, bootstrap);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void testSslEcho(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        final ExecutorService delegatedTaskExecutor = Executors.newCachedThreadPool();
        this.reset();
        sb.childOption(ChannelOption.AUTO_READ, (Object)this.autoRead);
        cb.option(ChannelOption.AUTO_READ, (Object)this.autoRead);
        sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            public void initChannel(Channel sch) {
                SocketSslEchoTest.this.serverChannel = sch;
                if (SocketSslEchoTest.this.serverUsesDelegatedTaskExecutor) {
                    SSLEngine sse = SocketSslEchoTest.this.serverCtx.newEngine(sch.alloc());
                    SocketSslEchoTest.this.serverSslHandler = new SslHandler(sse, (Executor)delegatedTaskExecutor);
                } else {
                    SocketSslEchoTest.this.serverSslHandler = SocketSslEchoTest.this.serverCtx.newHandler(sch.alloc());
                }
                SocketSslEchoTest.this.serverSslHandler.setHandshakeTimeoutMillis(0L);
                sch.pipeline().addLast("ssl", (ChannelHandler)SocketSslEchoTest.this.serverSslHandler);
                if (SocketSslEchoTest.this.useChunkedWriteHandler) {
                    sch.pipeline().addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
                }
                sch.pipeline().addLast("serverHandler", (ChannelHandler)SocketSslEchoTest.this.serverHandler);
            }
        });
        final CountDownLatch clientHandshakeEventLatch = new CountDownLatch(1);
        cb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            public void initChannel(Channel sch) {
                SocketSslEchoTest.this.clientChannel = sch;
                if (SocketSslEchoTest.this.clientUsesDelegatedTaskExecutor) {
                    SSLEngine cse = SocketSslEchoTest.this.clientCtx.newEngine(sch.alloc());
                    SocketSslEchoTest.this.clientSslHandler = new SslHandler(cse, (Executor)delegatedTaskExecutor);
                } else {
                    SocketSslEchoTest.this.clientSslHandler = SocketSslEchoTest.this.clientCtx.newHandler(sch.alloc());
                }
                SocketSslEchoTest.this.clientSslHandler.setHandshakeTimeoutMillis(0L);
                sch.pipeline().addLast("ssl", (ChannelHandler)SocketSslEchoTest.this.clientSslHandler);
                if (SocketSslEchoTest.this.useChunkedWriteHandler) {
                    sch.pipeline().addLast(new ChannelHandler[]{new ChunkedWriteHandler()});
                }
                sch.pipeline().addLast("clientHandler", (ChannelHandler)SocketSslEchoTest.this.clientHandler);
                sch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                        if (evt instanceof SslHandshakeCompletionEvent) {
                            clientHandshakeEventLatch.countDown();
                        }
                        ctx.fireUserEventTriggered(evt);
                    }
                }});
            }
        });
        Channel sc = sb.bind().sync().channel();
        cb.connect(sc.localAddress()).sync();
        Future clientHandshakeFuture = this.clientSslHandler.handshakeFuture();
        clientHandshakeFuture.sync();
        clientHandshakeEventLatch.await();
        this.clientChannel.writeAndFlush((Object)TestsuitePermutation.randomBufferType(this.clientChannel.alloc(), data, 0, 16384));
        this.clientSendCounter.set(16384);
        boolean needsRenegotiation = this.renegotiation.type == RenegotiationType.CLIENT_INITIATED;
        Future renegoFuture = null;
        while (this.clientSendCounter.get() < data.length) {
            int clientSendCounterVal = this.clientSendCounter.get();
            int length = Math.min(random.nextInt(65536), data.length - clientSendCounterVal);
            ByteBuf buf = TestsuitePermutation.randomBufferType(this.clientChannel.alloc(), data, clientSendCounterVal, length);
            if (this.useCompositeByteBuf) {
                buf = Unpooled.compositeBuffer().addComponent(true, buf);
            }
            ChannelFuture future = this.clientChannel.writeAndFlush((Object)buf);
            this.clientSendCounter.set(clientSendCounterVal += length);
            future.sync();
            if (!needsRenegotiation || clientSendCounterVal < data.length / 2) continue;
            needsRenegotiation = false;
            this.clientSslHandler.engine().setEnabledCipherSuites(new String[]{this.renegotiation.cipherSuite});
            renegoFuture = this.clientSslHandler.renegotiate();
            this.logStats("CLIENT RENEGOTIATES");
            org.junit.jupiter.api.Assertions.assertNotSame((Object)renegoFuture, (Object)clientHandshakeFuture);
        }
        while (this.clientRecvCounter.get() < data.length && this.serverException.get() == null && this.clientException.get() == null) {
            Thread.sleep(50L);
        }
        while (this.serverRecvCounter.get() < data.length && this.serverException.get() == null && this.clientException.get() == null) {
            Thread.sleep(50L);
        }
        if (renegoFuture != null) {
            renegoFuture.sync();
        }
        if (this.serverHandler.renegoFuture != null) {
            this.serverHandler.renegoFuture.sync();
        }
        this.serverChannel.close().awaitUninterruptibly();
        this.clientChannel.close().awaitUninterruptibly();
        sc.close().awaitUninterruptibly();
        delegatedTaskExecutor.shutdown();
        if (this.serverException.get() != null && !(this.serverException.get() instanceof IOException)) {
            throw this.serverException.get();
        }
        if (this.clientException.get() != null && !(this.clientException.get() instanceof IOException)) {
            throw this.clientException.get();
        }
        if (this.serverException.get() != null) {
            throw this.serverException.get();
        }
        if (this.clientException.get() != null) {
            throw this.clientException.get();
        }
        try {
            switch (this.renegotiation.type) {
                case SERVER_INITIATED: {
                    org.junit.jupiter.api.Assertions.assertEquals((Object)this.renegotiation.cipherSuite, (Object)this.serverSslHandler.engine().getSession().getCipherSuite());
                    org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)this.serverNegoCounter.get());
                    Assertions.assertThat((int)this.clientNegoCounter.get()).isIn(new Object[]{1, 2});
                    return;
                }
                case CLIENT_INITIATED: {
                    Assertions.assertThat((int)this.serverNegoCounter.get()).isIn(new Object[]{1, 2});
                    org.junit.jupiter.api.Assertions.assertEquals((Object)this.renegotiation.cipherSuite, (Object)this.clientSslHandler.engine().getSession().getCipherSuite());
                    org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)this.clientNegoCounter.get());
                    return;
                }
                case NONE: {
                    org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.serverNegoCounter.get());
                    org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)this.clientNegoCounter.get());
                    return;
                }
            }
            return;
        }
        finally {
            this.logStats("STATS");
        }
    }

    private void reset() {
        this.clientException.set(null);
        this.serverException.set(null);
        this.clientSendCounter.set(0);
        this.clientRecvCounter.set(0);
        this.serverRecvCounter.set(0);
        this.clientNegoCounter.set(0);
        this.serverNegoCounter.set(0);
        this.clientChannel = null;
        this.serverChannel = null;
        this.clientSslHandler = null;
        this.serverSslHandler = null;
    }

    void logStats(String message) {
        logger.debug("{}:\n\tclient { sent: {}, rcvd: {}, nego: {}, cipher: {} },\n\tserver { rcvd: {}, nego: {}, cipher: {} }", new Object[]{message, this.clientSendCounter, this.clientRecvCounter, this.clientNegoCounter, this.clientSslHandler.engine().getSession().getCipherSuite(), this.serverRecvCounter, this.serverNegoCounter, this.serverSslHandler.engine().getSession().getCipherSuite()});
    }

    static {
        data = new byte[0x100000];
        random.nextBytes(data);
        try {
            X509Bundle cert = new CertificateBuilder().rsa2048().subject("cn=localhost").setIsCertificateAuthority(true).buildSelfSigned();
            CERT_FILE = cert.toTempCertChainPem();
            KEY_FILE = cert.toTempPrivateKeyPem();
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private class EchoServerHandler
    extends EchoHandler {
        volatile Future<Channel> renegoFuture;

        EchoServerHandler(AtomicInteger recvCounter, AtomicInteger negoCounter, AtomicReference<Throwable> exception) {
            super(recvCounter, negoCounter, exception);
        }

        public final void channelRegistered(ChannelHandlerContext ctx) {
            this.renegoFuture = null;
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            if (!SocketSslEchoTest.this.autoRead) {
                ctx.read();
            }
            ctx.fireChannelActive();
        }

        public void channelRead0(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
            byte[] actual = new byte[in.readableBytes()];
            in.readBytes(actual);
            int lastIdx = this.recvCounter.get();
            for (int i = 0; i < actual.length; ++i) {
                org.junit.jupiter.api.Assertions.assertEquals((byte)data[i + lastIdx], (byte)actual[i]);
            }
            ByteBuf buf = TestsuitePermutation.randomBufferType(ctx.alloc(), actual, 0, actual.length);
            if (SocketSslEchoTest.this.useCompositeByteBuf) {
                buf = Unpooled.compositeBuffer().addComponent(true, buf);
            }
            ctx.writeAndFlush((Object)buf);
            this.recvCounter.addAndGet(actual.length);
            if (((SocketSslEchoTest)SocketSslEchoTest.this).renegotiation.type == RenegotiationType.SERVER_INITIATED && this.recvCounter.get() > data.length / 2 && this.renegoFuture == null) {
                SslHandler sslHandler = (SslHandler)ctx.pipeline().get(SslHandler.class);
                Future hf = sslHandler.handshakeFuture();
                org.junit.jupiter.api.Assertions.assertTrue((boolean)hf.isDone());
                sslHandler.engine().setEnabledCipherSuites(new String[]{((SocketSslEchoTest)SocketSslEchoTest.this).renegotiation.cipherSuite});
                SocketSslEchoTest.this.logStats("SERVER RENEGOTIATES");
                this.renegoFuture = sslHandler.renegotiate();
                org.junit.jupiter.api.Assertions.assertNotSame(this.renegoFuture, (Object)hf);
                org.junit.jupiter.api.Assertions.assertSame(this.renegoFuture, (Object)sslHandler.handshakeFuture());
                org.junit.jupiter.api.Assertions.assertFalse((boolean)this.renegoFuture.isDone());
            }
        }
    }

    private class EchoClientHandler
    extends EchoHandler {
        EchoClientHandler(AtomicInteger recvCounter, AtomicInteger negoCounter, AtomicReference<Throwable> exception) {
            super(recvCounter, negoCounter, exception);
        }

        public void handlerAdded(final ChannelHandlerContext ctx) {
            if (!SocketSslEchoTest.this.autoRead) {
                ((SslHandler)ctx.pipeline().get(SslHandler.class)).handshakeFuture().addListener((GenericFutureListener)new GenericFutureListener<Future<? super Channel>>(){

                    public void operationComplete(Future<? super Channel> future) {
                        ctx.read();
                    }
                });
            }
        }

        public void channelRead0(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
            byte[] actual = new byte[in.readableBytes()];
            in.readBytes(actual);
            int lastIdx = this.recvCounter.get();
            for (int i = 0; i < actual.length; ++i) {
                org.junit.jupiter.api.Assertions.assertEquals((byte)data[i + lastIdx], (byte)actual[i]);
            }
            this.recvCounter.addAndGet(actual.length);
        }
    }

    @ChannelHandler.Sharable
    private abstract class EchoHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        protected final AtomicInteger recvCounter;
        protected final AtomicInteger negoCounter;
        protected final AtomicReference<Throwable> exception;

        EchoHandler(AtomicInteger recvCounter, AtomicInteger negoCounter, AtomicReference<Throwable> exception) {
            this.recvCounter = recvCounter;
            this.negoCounter = negoCounter;
            this.exception = exception;
        }

        public final void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            if (!SocketSslEchoTest.this.autoRead) {
                ctx.read();
            }
            ctx.fireChannelReadComplete();
        }

        public final void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
            if (evt instanceof SslHandshakeCompletionEvent) {
                SslHandshakeCompletionEvent handshakeEvt = (SslHandshakeCompletionEvent)evt;
                if (handshakeEvt.cause() != null) {
                    logger.warn("Handshake failed:", handshakeEvt.cause());
                }
                org.junit.jupiter.api.Assertions.assertSame((Object)SslHandshakeCompletionEvent.SUCCESS, (Object)evt);
                this.negoCounter.incrementAndGet();
                SocketSslEchoTest.this.logStats("HANDSHAKEN");
            }
            ctx.fireUserEventTriggered(evt);
        }

        public final void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (logger.isWarnEnabled()) {
                logger.warn("Unexpected exception from the client side:", cause);
            }
            this.exception.compareAndSet(null, cause);
            ctx.close();
        }
    }

    protected static class Renegotiation {
        static final Renegotiation NONE = new Renegotiation(RenegotiationType.NONE, null);
        final RenegotiationType type;
        final String cipherSuite;

        Renegotiation(RenegotiationType type, String cipherSuite) {
            this.type = type;
            this.cipherSuite = cipherSuite;
        }

        public String toString() {
            if (this.type == RenegotiationType.NONE) {
                return "NONE";
            }
            return (Object)((Object)this.type) + "(" + this.cipherSuite + ')';
        }
    }

    protected static enum RenegotiationType {
        NONE,
        CLIENT_INITIATED,
        SERVER_INITIATED;

    }
}

