/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.handler.codec.Delimiters;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.testsuite.transport.AbstractComboTestsuiteTest;
import io.netty.testsuite.transport.socket.AbstractSocketTest;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;

public class SocketStringEchoTest
extends AbstractSocketTest {
    static final Random random = new Random(3L);
    static final String[] data = new String[1024];

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testStringEcho(TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<ServerBootstrap, Bootstrap>(){

            @Override
            public void run(ServerBootstrap serverBootstrap, Bootstrap bootstrap) throws Throwable {
                SocketStringEchoTest.this.testStringEcho(serverBootstrap, bootstrap);
            }
        });
    }

    public void testStringEcho(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        SocketStringEchoTest.testStringEcho(sb, cb, true);
    }

    @Test
    @Timeout(value=60000L, unit=TimeUnit.MILLISECONDS)
    public void testStringEchoNotAutoRead(TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<ServerBootstrap, Bootstrap>(){

            @Override
            public void run(ServerBootstrap serverBootstrap, Bootstrap bootstrap) throws Throwable {
                SocketStringEchoTest.this.testStringEchoNotAutoRead(serverBootstrap, bootstrap);
            }
        });
    }

    public void testStringEchoNotAutoRead(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        SocketStringEchoTest.testStringEcho(sb, cb, false);
    }

    private static void testStringEcho(ServerBootstrap sb, Bootstrap cb, boolean autoRead) throws Throwable {
        sb.childOption(ChannelOption.AUTO_READ, (Object)autoRead);
        cb.option(ChannelOption.AUTO_READ, (Object)autoRead);
        Promise serverDonePromise = ImmediateEventExecutor.INSTANCE.newPromise();
        Promise clientDonePromise = ImmediateEventExecutor.INSTANCE.newPromise();
        final StringEchoHandler sh = new StringEchoHandler(autoRead, (Promise<Void>)serverDonePromise);
        final StringEchoHandler ch = new StringEchoHandler(autoRead, (Promise<Void>)clientDonePromise);
        sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            public void initChannel(Channel sch) throws Exception {
                sch.pipeline().addLast("framer", (ChannelHandler)new DelimiterBasedFrameDecoder(512, Delimiters.lineDelimiter()));
                sch.pipeline().addLast("decoder", (ChannelHandler)new StringDecoder(CharsetUtil.ISO_8859_1));
                sch.pipeline().addBefore("decoder", "encoder", (ChannelHandler)new StringEncoder(CharsetUtil.ISO_8859_1));
                sch.pipeline().addAfter("decoder", "handler", (ChannelHandler)sh);
            }
        });
        cb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            public void initChannel(Channel sch) throws Exception {
                sch.pipeline().addLast("framer", (ChannelHandler)new DelimiterBasedFrameDecoder(512, Delimiters.lineDelimiter()));
                sch.pipeline().addLast("decoder", (ChannelHandler)new StringDecoder(CharsetUtil.ISO_8859_1));
                sch.pipeline().addBefore("decoder", "encoder", (ChannelHandler)new StringEncoder(CharsetUtil.ISO_8859_1));
                sch.pipeline().addAfter("decoder", "handler", (ChannelHandler)ch);
            }
        });
        Channel sc = sb.bind().sync().channel();
        Channel cc = cb.connect(sc.localAddress()).sync().channel();
        for (String element : data) {
            String delimiter = random.nextBoolean() ? "\r\n" : "\n";
            cc.writeAndFlush((Object)(element + delimiter));
        }
        ch.donePromise.sync();
        sh.donePromise.sync();
        sh.channel.close().sync();
        ch.channel.close().sync();
        sc.close().sync();
        if (sh.exception.get() != null && !(sh.exception.get() instanceof IOException)) {
            throw sh.exception.get();
        }
        if (ch.exception.get() != null && !(ch.exception.get() instanceof IOException)) {
            throw ch.exception.get();
        }
        if (sh.exception.get() != null) {
            throw sh.exception.get();
        }
        if (ch.exception.get() != null) {
            throw ch.exception.get();
        }
    }

    static {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            sb.setLength(0);
            int eLen = random.nextInt(512);
            int j = 1;
            while (sb.length() < eLen) {
                sb.append(String.format("%03X/%x.", i, j++));
            }
            if (sb.length() > eLen) {
                sb.setLength(eLen);
            }
            SocketStringEchoTest.data[i] = sb.toString();
        }
    }

    static class StringEchoHandler
    extends SimpleChannelInboundHandler<String> {
        private final boolean autoRead;
        private final Promise<Void> donePromise;
        private int dataIndex;
        volatile Channel channel;
        final AtomicReference<Throwable> exception = new AtomicReference();

        StringEchoHandler(boolean autoRead, Promise<Void> donePromise) {
            this.autoRead = autoRead;
            this.donePromise = donePromise;
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.channel = ctx.channel();
            if (!this.autoRead) {
                ctx.read();
            }
        }

        public void channelRead0(ChannelHandlerContext ctx, String msg) throws Exception {
            if (!data[this.dataIndex].equals(msg)) {
                this.donePromise.tryFailure((Throwable)new IllegalStateException("index: " + this.dataIndex + " didn't match!"));
                ctx.close();
                return;
            }
            if (this.channel.parent() != null) {
                String delimiter = random.nextBoolean() ? "\r\n" : "\n";
                this.channel.write((Object)(msg + delimiter));
            }
            if (++this.dataIndex >= data.length) {
                this.donePromise.setSuccess(null);
            }
        }

        public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            try {
                ctx.flush();
            }
            finally {
                if (!this.autoRead) {
                    ctx.read();
                }
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (this.exception.compareAndSet(null, cause)) {
                this.donePromise.tryFailure((Throwable)new IllegalStateException("exceptionCaught: " + ctx.channel(), cause));
                ctx.close();
            }
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            this.donePromise.tryFailure((Throwable)new IllegalStateException("channelInactive: " + ctx.channel()));
        }
    }
}

