/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.ssl.SslProvider;
import io.netty.pkitesting.CertificateBuilder;
import io.netty.pkitesting.X509Bundle;
import io.netty.testsuite.transport.AbstractComboTestsuiteTest;
import io.netty.testsuite.transport.socket.AbstractSocketTest;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class SocketSslGreetingTest
extends AbstractSocketTest {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(SocketSslGreetingTest.class);
    private static final LogLevel LOG_LEVEL = LogLevel.TRACE;
    private static final File CERT_FILE;
    private static final File KEY_FILE;

    public static Collection<Object[]> data() throws Exception {
        ArrayList<SslContext> serverContexts = new ArrayList<SslContext>();
        serverContexts.add(SslContextBuilder.forServer((File)CERT_FILE, (File)KEY_FILE).sslProvider(SslProvider.JDK).build());
        ArrayList<SslContext> clientContexts = new ArrayList<SslContext>();
        clientContexts.add(SslContextBuilder.forClient().sslProvider(SslProvider.JDK).endpointIdentificationAlgorithm(null).trustManager(CERT_FILE).build());
        boolean hasOpenSsl = OpenSsl.isAvailable();
        if (hasOpenSsl) {
            serverContexts.add(SslContextBuilder.forServer((File)CERT_FILE, (File)KEY_FILE).sslProvider(SslProvider.OPENSSL).build());
            clientContexts.add(SslContextBuilder.forClient().sslProvider(SslProvider.OPENSSL).endpointIdentificationAlgorithm(null).trustManager(CERT_FILE).build());
        } else {
            logger.warn("OpenSSL is unavailable and thus will not be tested.", OpenSsl.unavailabilityCause());
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (SslContext sc : serverContexts) {
            for (SslContext cc : clientContexts) {
                params.add(new Object[]{sc, cc, true});
                params.add(new Object[]{sc, cc, false});
            }
        }
        return params;
    }

    private static SslHandler newSslHandler(SslContext sslCtx, ByteBufAllocator allocator, Executor executor) {
        if (executor == null) {
            return sslCtx.newHandler(allocator);
        }
        return sslCtx.newHandler(allocator, executor);
    }

    @ParameterizedTest(name="{index}: serverEngine = {0}, clientEngine = {1}, delegate = {2}")
    @MethodSource(value={"data"})
    @Timeout(value=30000L, unit=TimeUnit.MILLISECONDS)
    public void testSslGreeting(final SslContext serverCtx, final SslContext clientCtx, final boolean delegate, TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<ServerBootstrap, Bootstrap>(){

            @Override
            public void run(ServerBootstrap serverBootstrap, Bootstrap bootstrap) throws Throwable {
                SocketSslGreetingTest.this.testSslGreeting((ServerBootstrap)SocketSslGreetingTest.this.sb, (Bootstrap)SocketSslGreetingTest.this.cb, serverCtx, clientCtx, delegate);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSslGreeting(ServerBootstrap sb, Bootstrap cb, final SslContext serverCtx, final SslContext clientCtx, boolean delegate) throws Throwable {
        final ServerHandler sh = new ServerHandler();
        final ClientHandler ch = new ClientHandler();
        final ExecutorService executorService = delegate ? Executors.newCachedThreadPool() : null;
        try {
            sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                public void initChannel(Channel sch) throws Exception {
                    ChannelPipeline p = sch.pipeline();
                    p.addLast(new ChannelHandler[]{SocketSslGreetingTest.newSslHandler(serverCtx, sch.alloc(), executorService)});
                    p.addLast(new ChannelHandler[]{new LoggingHandler(LOG_LEVEL)});
                    p.addLast(new ChannelHandler[]{sh});
                }
            });
            cb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

                public void initChannel(Channel sch) throws Exception {
                    ChannelPipeline p = sch.pipeline();
                    p.addLast(new ChannelHandler[]{SocketSslGreetingTest.newSslHandler(clientCtx, sch.alloc(), executorService)});
                    p.addLast(new ChannelHandler[]{new LoggingHandler(LOG_LEVEL)});
                    p.addLast(new ChannelHandler[]{ch});
                }
            });
            Channel sc = sb.bind().sync().channel();
            Channel cc = cb.connect(sc.localAddress()).sync().channel();
            ch.latch.await();
            sh.channel.close().awaitUninterruptibly();
            cc.close().awaitUninterruptibly();
            sc.close().awaitUninterruptibly();
            if (sh.exception.get() != null && !(sh.exception.get() instanceof IOException)) {
                throw sh.exception.get();
            }
            if (ch.exception.get() != null && !(ch.exception.get() instanceof IOException)) {
                throw ch.exception.get();
            }
            if (sh.exception.get() != null) {
                throw sh.exception.get();
            }
            if (ch.exception.get() != null) {
                throw ch.exception.get();
            }
        }
        finally {
            if (executorService != null) {
                executorService.shutdown();
                Assertions.assertTrue((boolean)executorService.awaitTermination(5L, TimeUnit.SECONDS));
            }
        }
    }

    static {
        try {
            X509Bundle cert = new CertificateBuilder().subject("cn=localhost").setIsCertificateAuthority(true).buildSelfSigned();
            CERT_FILE = cert.toTempCertChainPem();
            KEY_FILE = cert.toTempPrivateKeyPem();
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static class ServerHandler
    extends SimpleChannelInboundHandler<String> {
        volatile Channel channel;
        final AtomicReference<Throwable> exception = new AtomicReference();

        private ServerHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, String msg) throws Exception {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.channel = ctx.channel();
            this.channel.writeAndFlush((Object)ctx.alloc().buffer().writeByte(97));
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (logger.isWarnEnabled()) {
                logger.warn("Unexpected exception from the server side", cause);
            }
            this.exception.compareAndSet(null, cause);
            ctx.close();
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            SslHandshakeCompletionEvent event;
            if (evt instanceof SslHandshakeCompletionEvent && (event = (SslHandshakeCompletionEvent)evt).isSuccess()) {
                SSLSession session;
                block8: {
                    session = ((SslHandler)ctx.pipeline().get(SslHandler.class)).engine().getSession();
                    try {
                        session.getPeerCertificates();
                        Assertions.fail();
                    }
                    catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                        // empty catch block
                    }
                    try {
                        session.getPeerCertificateChain();
                        Assertions.fail();
                    }
                    catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                    }
                    catch (UnsupportedOperationException e) {
                        if (PlatformDependent.javaVersion() >= 15) break block8;
                        throw e;
                    }
                }
                try {
                    session.getPeerPrincipal();
                    Assertions.fail();
                }
                catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                    // empty catch block
                }
            }
            ctx.fireUserEventTriggered(evt);
        }
    }

    private static class ClientHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        final AtomicReference<Throwable> exception = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);

        private ClientHandler() {
        }

        public void channelRead0(ChannelHandlerContext ctx, ByteBuf buf) throws Exception {
            Assertions.assertEquals((int)97, (int)buf.readByte());
            Assertions.assertFalse((boolean)buf.isReadable());
            this.latch.countDown();
            ctx.close();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (logger.isWarnEnabled()) {
                logger.warn("Unexpected exception from the client side", cause);
            }
            this.exception.compareAndSet(null, cause);
            ctx.close();
        }
    }
}

