/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.testsuite.transport.AbstractComboTestsuiteTest;
import io.netty.testsuite.transport.socket.AbstractSocketTest;
import io.netty.util.ReferenceCountUtil;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;

public class SocketConditionalWritabilityTest
extends AbstractSocketTest {
    @Test
    @Timeout(value=30000L, unit=TimeUnit.MILLISECONDS)
    public void testConditionalWritability(TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<ServerBootstrap, Bootstrap>(){

            @Override
            public void run(ServerBootstrap serverBootstrap, Bootstrap bootstrap) throws Throwable {
                SocketConditionalWritabilityTest.this.testConditionalWritability(serverBootstrap, bootstrap);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConditionalWritability(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        Channel serverChannel = null;
        Channel clientChannel = null;
        try {
            int expectedBytes = 0x6400000;
            int maxWriteChunkSize = 16384;
            final CountDownLatch latch = new CountDownLatch(1);
            sb.childOption(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(8192, 16384));
            sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{new ChannelDuplexHandler(){
                        private int bytesWritten;

                        public void channelRead(ChannelHandlerContext ctx, Object msg) {
                            ReferenceCountUtil.release((Object)msg);
                            this.writeRemainingBytes(ctx);
                        }

                        public void flush(ChannelHandlerContext ctx) {
                            if (ctx.channel().isWritable()) {
                                this.writeRemainingBytes(ctx);
                            } else {
                                ctx.flush();
                            }
                        }

                        public void channelWritabilityChanged(ChannelHandlerContext ctx) {
                            if (ctx.channel().isWritable()) {
                                this.writeRemainingBytes(ctx);
                            }
                            ctx.fireChannelWritabilityChanged();
                        }

                        private void writeRemainingBytes(ChannelHandlerContext ctx) {
                            while (ctx.channel().isWritable() && this.bytesWritten < 0x6400000) {
                                int chunkSize = Math.min(0x6400000 - this.bytesWritten, 16384);
                                this.bytesWritten += chunkSize;
                                ctx.write((Object)ctx.alloc().buffer(chunkSize).writeZero(chunkSize));
                            }
                            ctx.flush();
                        }
                    }});
                }
            });
            serverChannel = sb.bind().syncUninterruptibly().channel();
            cb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){
                        private int totalRead;

                        public void channelActive(ChannelHandlerContext ctx) {
                            ctx.writeAndFlush((Object)ctx.alloc().buffer(1).writeByte(0));
                        }

                        public void channelRead(ChannelHandlerContext ctx, Object msg) {
                            if (msg instanceof ByteBuf) {
                                this.totalRead += ((ByteBuf)msg).readableBytes();
                                if (this.totalRead == 0x6400000) {
                                    latch.countDown();
                                }
                            }
                            ReferenceCountUtil.release((Object)msg);
                        }
                    }});
                }
            });
            clientChannel = cb.connect(serverChannel.localAddress()).syncUninterruptibly().channel();
            latch.await();
        }
        finally {
            if (serverChannel != null) {
                serverChannel.close();
            }
            if (clientChannel != null) {
                clientChannel.close();
            }
        }
    }
}

