/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.testsuite.transport.TestsuitePermutation;
import io.netty.testsuite.util.TestUtils;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.List;
import org.junit.jupiter.api.TestInfo;

public abstract class AbstractComboTestsuiteTest<SB extends AbstractBootstrap<?, ?>, CB extends AbstractBootstrap<?, ?>> {
    protected final InternalLogger logger = InternalLoggerFactory.getInstance(this.getClass());
    protected volatile CB cb;
    protected volatile SB sb;

    protected abstract List<TestsuitePermutation.BootstrapComboFactory<SB, CB>> newFactories();

    protected List<ByteBufAllocator> newAllocators() {
        return TestsuitePermutation.allocator();
    }

    protected void run(TestInfo testInfo, Runner<SB, CB> runner) throws Throwable {
        List<TestsuitePermutation.BootstrapComboFactory<SB, CB>> combos = this.newFactories();
        String methodName = TestUtils.testMethodName(testInfo);
        for (ByteBufAllocator allocator : this.newAllocators()) {
            int i = 0;
            for (TestsuitePermutation.BootstrapComboFactory<SB, CB> e : combos) {
                this.sb = e.newServerInstance();
                this.cb = e.newClientInstance();
                this.configure(this.sb, this.cb, allocator);
                this.logger.info(String.format("Running: %s %d of %d (%s + %s) with %s", methodName, ++i, combos.size(), this.sb, this.cb, StringUtil.simpleClassName((Object)allocator)));
                runner.run(this.sb, this.cb);
            }
        }
    }

    protected abstract void configure(SB var1, CB var2, ByteBufAllocator var3);

    public static interface Runner<SB extends AbstractBootstrap<?, ?>, CB extends AbstractBootstrap<?, ?>> {
        public void run(SB var1, CB var2) throws Throwable;
    }
}

