/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.sctp;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.sctp.nio.NioSctpChannel;
import io.netty.channel.sctp.nio.NioSctpServerChannel;
import io.netty.channel.sctp.oio.OioSctpChannel;
import io.netty.channel.sctp.oio.OioSctpServerChannel;
import io.netty.testsuite.transport.TestsuitePermutation;
import io.netty.testsuite.util.TestUtils;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ThreadFactory;

public final class SctpTestPermutation {
    private static final int NUM_THREADS = 4;
    private static final EventLoopGroup NIO_GROUP = new NioEventLoopGroup(4, (ThreadFactory)new DefaultThreadFactory("testsuite-sctp-nio", true));
    private static final EventLoopGroup OIO_GROUP = new OioEventLoopGroup(Integer.MAX_VALUE, (ThreadFactory)new DefaultThreadFactory("testsuite-sctp-oio", true));

    static List<TestsuitePermutation.BootstrapFactory<ServerBootstrap>> sctpServerChannel() {
        if (!TestUtils.isSctpSupported()) {
            return Collections.emptyList();
        }
        ArrayList<TestsuitePermutation.BootstrapFactory<ServerBootstrap>> list = new ArrayList<TestsuitePermutation.BootstrapFactory<ServerBootstrap>>();
        list.add(new TestsuitePermutation.BootstrapFactory<ServerBootstrap>(){

            @Override
            public ServerBootstrap newInstance() {
                return (ServerBootstrap)new ServerBootstrap().group(NIO_GROUP).channel(NioSctpServerChannel.class);
            }
        });
        list.add(new TestsuitePermutation.BootstrapFactory<ServerBootstrap>(){

            @Override
            public ServerBootstrap newInstance() {
                return (ServerBootstrap)new ServerBootstrap().group(OIO_GROUP).channel(OioSctpServerChannel.class);
            }
        });
        return list;
    }

    static List<TestsuitePermutation.BootstrapFactory<Bootstrap>> sctpClientChannel() {
        if (!TestUtils.isSctpSupported()) {
            return Collections.emptyList();
        }
        ArrayList<TestsuitePermutation.BootstrapFactory<Bootstrap>> list = new ArrayList<TestsuitePermutation.BootstrapFactory<Bootstrap>>();
        list.add(new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            @Override
            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)new Bootstrap().group(NIO_GROUP)).channel(NioSctpChannel.class);
            }
        });
        list.add(new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            @Override
            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)new Bootstrap().group(OIO_GROUP)).channel(OioSctpChannel.class);
            }
        });
        return list;
    }

    static List<TestsuitePermutation.BootstrapComboFactory<ServerBootstrap, Bootstrap>> sctpChannel() {
        ArrayList<TestsuitePermutation.BootstrapComboFactory<ServerBootstrap, Bootstrap>> list = new ArrayList<TestsuitePermutation.BootstrapComboFactory<ServerBootstrap, Bootstrap>>();
        List<TestsuitePermutation.BootstrapFactory<ServerBootstrap>> sbfs = SctpTestPermutation.sctpServerChannel();
        List<TestsuitePermutation.BootstrapFactory<Bootstrap>> cbfs = SctpTestPermutation.sctpClientChannel();
        for (TestsuitePermutation.BootstrapFactory<ServerBootstrap> sbf : sbfs) {
            for (TestsuitePermutation.BootstrapFactory<Bootstrap> cbf : cbfs) {
                final TestsuitePermutation.BootstrapFactory<ServerBootstrap> sbf0 = sbf;
                final TestsuitePermutation.BootstrapFactory<Bootstrap> cbf0 = cbf;
                list.add(new TestsuitePermutation.BootstrapComboFactory<ServerBootstrap, Bootstrap>(){

                    @Override
                    public ServerBootstrap newServerInstance() {
                        return (ServerBootstrap)sbf0.newInstance();
                    }

                    @Override
                    public Bootstrap newClientInstance() {
                        return (Bootstrap)cbf0.newInstance();
                    }
                });
            }
        }
        return list;
    }

    private SctpTestPermutation() {
    }
}

