/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.testsuite.transport.socket.DatagramUnicastIPv6Test;
import io.netty.util.NetUtil;
import io.netty.util.internal.PlatformDependent;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class DatagramUnicastIPv6MappedTest
extends DatagramUnicastIPv6Test {
    @Override
    protected SocketAddress newSocketAddress() {
        return new InetSocketAddress(0);
    }

    @Override
    protected InetSocketAddress sendToAddress(InetSocketAddress serverAddress) {
        InetAddress addr = serverAddress.getAddress();
        if (addr.isAnyLocalAddress()) {
            return new InetSocketAddress(NetUtil.LOCALHOST4, serverAddress.getPort());
        }
        return serverAddress;
    }

    @Override
    protected boolean disconnectMightFail(DatagramChannel channel) {
        if (channel instanceof NioDatagramChannel && PlatformDependent.javaVersion() < 20) {
            return true;
        }
        return super.disconnectMightFail(channel);
    }
}

