/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelOption;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.testsuite.transport.AbstractComboTestsuiteTest;
import io.netty.testsuite.transport.TestsuitePermutation;
import io.netty.testsuite.transport.socket.SocketTestPermutation;
import io.netty.util.NetUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;

public abstract class AbstractDatagramTest
extends AbstractComboTestsuiteTest<Bootstrap, Bootstrap> {
    @Override
    protected List<TestsuitePermutation.BootstrapComboFactory<Bootstrap, Bootstrap>> newFactories() {
        return SocketTestPermutation.INSTANCE.datagram(this.socketInternetProtocalFamily());
    }

    @Override
    protected void configure(Bootstrap bootstrap, Bootstrap bootstrap2, ByteBufAllocator allocator) {
        bootstrap.option(ChannelOption.ALLOCATOR, (Object)allocator);
        bootstrap2.option(ChannelOption.ALLOCATOR, (Object)allocator);
    }

    protected SocketAddress newSocketAddress() {
        switch (this.socketInternetProtocalFamily()) {
            case IPv4: {
                return new InetSocketAddress(NetUtil.LOCALHOST4, 0);
            }
            case IPv6: {
                return new InetSocketAddress(NetUtil.LOCALHOST6, 0);
            }
        }
        throw new AssertionError();
    }

    protected InternetProtocolFamily internetProtocolFamily() {
        return InternetProtocolFamily.IPv4;
    }

    protected InternetProtocolFamily groupInternetProtocalFamily() {
        return this.internetProtocolFamily();
    }

    protected InternetProtocolFamily socketInternetProtocalFamily() {
        return this.internetProtocolFamily();
    }
}

