/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ChannelFactory;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.socket.oio.OioDatagramChannel;
import io.netty.channel.socket.oio.OioServerSocketChannel;
import io.netty.channel.socket.oio.OioSocketChannel;
import io.netty.testsuite.transport.TestsuitePermutation;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadFactory;

public class SocketTestPermutation {
    static final SocketTestPermutation INSTANCE = new SocketTestPermutation();
    protected static final int BOSSES = 2;
    protected static final int WORKERS = 3;
    protected static final int OIO_SO_TIMEOUT = 10;
    protected final EventLoopGroup nioBossGroup = new NioEventLoopGroup(2, (ThreadFactory)new DefaultThreadFactory("testsuite-nio-boss", true));
    protected final EventLoopGroup nioWorkerGroup = new NioEventLoopGroup(3, (ThreadFactory)new DefaultThreadFactory("testsuite-nio-worker", true));
    protected final EventLoopGroup oioBossGroup = new OioEventLoopGroup(Integer.MAX_VALUE, (ThreadFactory)new DefaultThreadFactory("testsuite-oio-boss", true));
    protected final EventLoopGroup oioWorkerGroup = new OioEventLoopGroup(Integer.MAX_VALUE, (ThreadFactory)new DefaultThreadFactory("testsuite-oio-worker", true));

    protected <A extends AbstractBootstrap<?, ?>, B extends AbstractBootstrap<?, ?>> List<TestsuitePermutation.BootstrapComboFactory<A, B>> combo(List<TestsuitePermutation.BootstrapFactory<A>> sbfs, List<TestsuitePermutation.BootstrapFactory<B>> cbfs) {
        ArrayList<TestsuitePermutation.BootstrapComboFactory<A, B>> list = new ArrayList<TestsuitePermutation.BootstrapComboFactory<A, B>>();
        for (TestsuitePermutation.BootstrapFactory<A> sbf : sbfs) {
            for (TestsuitePermutation.BootstrapFactory<B> cbf : cbfs) {
                final TestsuitePermutation.BootstrapFactory<A> sbf0 = sbf;
                final TestsuitePermutation.BootstrapFactory<B> cbf0 = cbf;
                list.add(new TestsuitePermutation.BootstrapComboFactory<A, B>(){

                    @Override
                    public A newServerInstance() {
                        return sbf0.newInstance();
                    }

                    @Override
                    public B newClientInstance() {
                        return cbf0.newInstance();
                    }
                });
            }
        }
        return list;
    }

    public List<TestsuitePermutation.BootstrapComboFactory<ServerBootstrap, Bootstrap>> socket() {
        List sbfs = this.serverSocket();
        List cbfs = this.clientSocket();
        List<TestsuitePermutation.BootstrapComboFactory<ServerBootstrap, Bootstrap>> list = this.combo(sbfs, cbfs);
        list.remove(list.size() - 1);
        return list;
    }

    public List<TestsuitePermutation.BootstrapComboFactory<Bootstrap, Bootstrap>> datagram() {
        List bfs = Arrays.asList(new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            @Override
            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)new Bootstrap().group(SocketTestPermutation.this.nioWorkerGroup)).channelFactory((ChannelFactory)new ChannelFactory<Channel>(){

                    public Channel newChannel() {
                        return new NioDatagramChannel(InternetProtocolFamily.IPv4);
                    }

                    public String toString() {
                        return NioDatagramChannel.class.getSimpleName() + ".class";
                    }
                });
            }
        }, new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            @Override
            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)new Bootstrap().group(SocketTestPermutation.this.oioWorkerGroup)).channel(OioDatagramChannel.class);
            }
        });
        return this.combo(bfs, bfs);
    }

    public List<TestsuitePermutation.BootstrapFactory<ServerBootstrap>> serverSocket() {
        return Arrays.asList(new TestsuitePermutation.BootstrapFactory<ServerBootstrap>(){

            @Override
            public ServerBootstrap newInstance() {
                return (ServerBootstrap)new ServerBootstrap().group(SocketTestPermutation.this.nioBossGroup, SocketTestPermutation.this.nioWorkerGroup).channel(NioServerSocketChannel.class);
            }
        }, new TestsuitePermutation.BootstrapFactory<ServerBootstrap>(){

            @Override
            public ServerBootstrap newInstance() {
                return (ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(SocketTestPermutation.this.oioBossGroup, SocketTestPermutation.this.oioWorkerGroup).channel(OioServerSocketChannel.class)).option(ChannelOption.SO_TIMEOUT, (Object)10);
            }
        });
    }

    public List<TestsuitePermutation.BootstrapFactory<Bootstrap>> clientSocket() {
        return Arrays.asList(new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            @Override
            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)new Bootstrap().group(SocketTestPermutation.this.nioWorkerGroup)).channel(NioSocketChannel.class);
            }
        }, new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            @Override
            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(SocketTestPermutation.this.oioWorkerGroup)).channel(OioSocketChannel.class)).option(ChannelOption.SO_TIMEOUT, (Object)10);
            }
        });
    }
}

