/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.testsuite.transport.TestsuitePermutation;
import io.netty.testsuite.util.TestUtils;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.junit.Rule;
import org.junit.rules.TestName;

public abstract class AbstractComboTestsuiteTest<SB extends AbstractBootstrap<?, ?>, CB extends AbstractBootstrap<?, ?>> {
    private final Class<SB> sbClazz;
    private final Class<CB> cbClazz;
    protected final InternalLogger logger = InternalLoggerFactory.getInstance(this.getClass());
    protected volatile CB cb;
    protected volatile SB sb;
    @Rule
    public final TestName testName = new TestName();

    protected AbstractComboTestsuiteTest(Class<SB> sbClazz, Class<CB> cbClazz) {
        this.sbClazz = sbClazz;
        this.cbClazz = cbClazz;
    }

    protected abstract List<TestsuitePermutation.BootstrapComboFactory<SB, CB>> newFactories();

    protected List<ByteBufAllocator> newAllocators() {
        return TestsuitePermutation.allocator();
    }

    protected void run() throws Throwable {
        List<TestsuitePermutation.BootstrapComboFactory<SB, CB>> combos = this.newFactories();
        for (ByteBufAllocator allocator : this.newAllocators()) {
            int i = 0;
            for (TestsuitePermutation.BootstrapComboFactory<SB, CB> e : combos) {
                this.sb = e.newServerInstance();
                this.cb = e.newClientInstance();
                this.configure(this.sb, this.cb, allocator);
                this.logger.info(String.format("Running: %s %d of %d (%s + %s) with %s", this.testName.getMethodName(), ++i, combos.size(), this.sb, this.cb, StringUtil.simpleClassName((Object)allocator)));
                try {
                    Method m = this.getClass().getMethod(TestUtils.testMethodName(this.testName), this.sbClazz, this.cbClazz);
                    m.invoke((Object)this, this.sb, this.cb);
                }
                catch (InvocationTargetException ex) {
                    throw ex.getCause();
                }
            }
        }
    }

    protected abstract void configure(SB var1, CB var2, ByteBufAllocator var3);
}

