/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.svm;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.AsciiString;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.concurrent.CompletableFuture;

public class HttpNativeServerHandler
extends SimpleChannelInboundHandler<HttpObject> {
    private static final byte[] CONTENT = new byte[]{72, 101, 108, 108, 111, 32, 78, 97, 116, 105, 118, 101};
    private static final AsciiString KEEP_ALIVE = AsciiString.cached((String)"keep-alive");
    private final CompletableFuture<Void> httpRequestFuture;

    public HttpNativeServerHandler(CompletableFuture<Void> httpRequestFuture) {
        this.httpRequestFuture = httpRequestFuture;
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    public void channelRead0(ChannelHandlerContext ctx, HttpObject msg) {
        if (msg instanceof HttpRequest) {
            HttpRequest req = (HttpRequest)msg;
            boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)req);
            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])CONTENT));
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain");
            response.headers().setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, response.content().readableBytes());
            this.httpRequestFuture.complete(null);
            if (!keepAlive) {
                ctx.write((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            } else {
                response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)KEEP_ALIVE);
                ctx.write((Object)response);
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.httpRequestFuture.completeExceptionally(cause);
        cause.printStackTrace();
        ctx.close();
    }
}

