/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver.dns;

import io.netty.resolver.dns.ResolvConf;
import java.io.BufferedReader;
import java.io.StringReader;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;
import org.junit.jupiter.api.condition.OS;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class ResolvConfTest {
    @Test
    @DisabledOnOs(value={OS.WINDOWS})
    public void readSystem() {
        MatcherAssert.assertThat((Object)ResolvConf.system().getNameservers().size(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(0))));
    }

    @ParameterizedTest
    @MethodSource
    public void scenarios(String resolvConf, List<String> nameservers) throws Exception {
        Assertions.assertIterableEquals((Iterable)ResolvConf.fromReader((BufferedReader)new BufferedReader(new StringReader(resolvConf))).getNameservers(), (Iterable)nameservers.stream().map(new Function<String, InetSocketAddress>(){

            @Override
            public InetSocketAddress apply(String n) {
                return new InetSocketAddress(n, 53);
            }
        }).collect(Collectors.toList()));
    }

    static List<Arguments> scenarios() {
        return Arrays.asList(Arguments.arguments((Object[])new Object[]{"", Collections.emptyList()}), Arguments.arguments((Object[])new Object[]{"# some comment\n# nameserver hello\n\nnameserver 1.2.3.4\nnameserver 127.1.2.3", Arrays.asList("1.2.3.4", "127.1.2.3")}), Arguments.arguments((Object[])new Object[]{"# some comment\n# nameserver hello\n\nnameserver 1.2.3.4\nnameserver 127.1.2.3", Arrays.asList("1.2.3.4", "127.1.2.3")}), Arguments.arguments((Object[])new Object[]{"# some comment\nnameserver 0:0:0:0:0:0:0:1\nnameserver 127.0.0.1", Arrays.asList("0:0:0:0:0:0:0:1", "127.0.0.1")}), Arguments.arguments((Object[])new Object[]{"# options and search are ignored\nnameserver 127.0.0.53\noptions edns0 trust-adsearch netty.io projectnessie.org", Arrays.asList("127.0.0.53")}));
    }
}

