/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver.dns;

import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.resolver.dns.DefaultDnsCnameCache;
import io.netty.resolver.dns.DnsCnameCache;
import io.netty.resolver.dns.DnsResolveContext;
import java.net.UnknownHostException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DnsResolveContextTest {
    private static final String HOSTNAME = "netty.io.";

    @Test
    public void testCnameLoop() {
        for (int i = 1; i < 128; ++i) {
            try {
                DnsResolveContext.cnameResolveFromCache((DnsCnameCache)DnsResolveContextTest.buildCache(i), (String)HOSTNAME);
                Assertions.fail();
                continue;
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
    }

    private static DnsCnameCache buildCache(int chainLength) {
        EmbeddedChannel channel = new EmbeddedChannel();
        DefaultDnsCnameCache cache = new DefaultDnsCnameCache();
        if (chainLength == 1) {
            cache.cache(HOSTNAME, HOSTNAME, Long.MAX_VALUE, channel.eventLoop());
        } else {
            String lastName = HOSTNAME;
            for (int i = 1; i < chainLength; ++i) {
                String nextName = i + "." + lastName;
                cache.cache(lastName, nextName, Long.MAX_VALUE, channel.eventLoop());
                lastName = nextName;
            }
            cache.cache(lastName, HOSTNAME, Long.MAX_VALUE, channel.eventLoop());
        }
        return cache;
    }
}

