/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.concurrent;

import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.concurrent.FastThreadLocalThread;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;

@Measurement(iterations=10)
@Warmup(iterations=10)
@BenchmarkMode(value={Mode.AverageTime})
@State(value=Scope.Thread)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class FastThreadLocalCheckBenchmark
extends AbstractMicrobenchmark {
    @Param(value={"8", "16", "32", "64", "128", "256"})
    public int eventLoops;
    private Thread[] eventLoopThreads;
    private CountDownLatch eventLoopControl;

    public FastThreadLocalCheckBenchmark() {
        super(true, true);
    }

    @Setup
    public void setup() {
        if (Thread.currentThread() instanceof io.netty.util.concurrent.FastThreadLocalThread) {
            throw new IllegalStateException("This benchmark must not be run in a FastThreadLocalThread");
        }
        long benchmarkThreadId = Thread.currentThread().getId();
        long[] eventLoopIds = new long[this.eventLoops];
        for (int i = 0; i < this.eventLoops; ++i) {
            eventLoopIds[i] = benchmarkThreadId + (long)i + 1L;
        }
        this.eventLoopControl = new CountDownLatch(1);
        final CountDownLatch eventLoopsRegistered = new CountDownLatch(this.eventLoops);
        this.eventLoopThreads = new Thread[this.eventLoops];
        int i = 0;
        for (long eventLoopId : eventLoopIds) {
            class FastThreadLocalThread
            extends Thread {
                private final long id;

                FastThreadLocalThread(long id) {
                    this.id = id;
                }

                @Override
                public long getId() {
                    return this.id;
                }

                @Override
                public void run() {
                    io.netty.util.concurrent.FastThreadLocalThread.runWithFastThreadLocal(() -> {
                        try {
                            eventLoopsRegistered.countDown();
                            FastThreadLocalCheckBenchmark.this.eventLoopControl.await();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    });
                }
            }
            FastThreadLocalThread thread = new FastThreadLocalThread(eventLoopId);
            thread.start();
            this.eventLoopThreads[i++] = thread;
        }
        try {
            eventLoopsRegistered.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Benchmark
    public boolean isFastThreadLocalThread() {
        return FastThreadLocalThread.currentThreadHasFastThreadLocal();
    }

    @TearDown
    public void tearDown() {
        this.eventLoopControl.countDown();
        for (Thread thread : this.eventLoopThreads) {
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

