/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.concurrent;

import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.nio.NioIoHandler;
import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.concurrent.AbstractScheduledEventExecutor;
import io.netty.util.concurrent.ScheduledFutureTask;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

@Warmup(iterations=5, time=3, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=10, time=3, timeUnit=TimeUnit.SECONDS)
@State(value=Scope.Benchmark)
public class ScheduledFutureTaskDeadlineBenchmark
extends AbstractMicrobenchmark {
    @Benchmark
    @Threads(value=1)
    public long requestDeadline(ThreadState threadState) {
        return threadState.future.delayNanos();
    }

    @State(value=Scope.Thread)
    public static class ThreadState {
        AbstractScheduledEventExecutor eventLoop;
        ScheduledFutureTask<?> future;

        @Setup(value=Level.Trial)
        public void reset() {
            this.eventLoop = (AbstractScheduledEventExecutor)new MultiThreadIoEventLoopGroup(1, NioIoHandler.newFactory()).next();
            this.future = (ScheduledFutureTask)this.eventLoop.schedule(new Runnable(){

                @Override
                public void run() {
                }
            }, 100L, TimeUnit.DAYS);
        }

        @TearDown(value=Level.Trial)
        public void shutdown() {
            this.future.cancel(true);
            this.eventLoop.parent().shutdownGracefully().awaitUninterruptibly();
        }
    }
}

