/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbenchmark.common;

import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.PlatformDependent;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

@Threads(value=1)
@Measurement(iterations=5, time=200, timeUnit=TimeUnit.MILLISECONDS)
@Warmup(iterations=5, time=200, timeUnit=TimeUnit.MILLISECONDS)
public class AsciiStringBenchmark
extends AbstractMicrobenchmark {
    @Param(value={"3", "5", "7", "8", "10", "20", "50", "100", "1000"})
    public int size;
    private AsciiString asciiString;
    private String string;
    private static final Random random = new Random();
    private AsciiString connection;
    private AsciiString Connection;

    @Setup(value=Level.Trial)
    public void setup() {
        byte[] bytes = new byte[this.size];
        random.nextBytes(bytes);
        this.asciiString = new AsciiString(bytes, false);
        this.string = new String(bytes, CharsetUtil.US_ASCII);
        this.connection = AsciiString.cached((String)"connection");
        this.Connection = AsciiString.cached((String)"Connection");
    }

    @Benchmark
    public boolean equalsIgnoreCaseBench() {
        return this.Connection.contentEqualsIgnoreCase((CharSequence)this.connection);
    }

    @Benchmark
    public int hashCodeBenchBytesOld() {
        int h = 0;
        int end = this.asciiString.arrayOffset() + this.asciiString.length();
        for (int i = this.asciiString.arrayOffset(); i < end; ++i) {
            h = h * 31 + (this.asciiString.array()[i] & 0x1F);
        }
        return h;
    }

    @Benchmark
    public int hashCodeBenchBytesNew() {
        return PlatformDependent.hashCodeAscii((byte[])this.asciiString.array(), (int)this.asciiString.arrayOffset(), (int)this.asciiString.length());
    }

    @Benchmark
    public int hashCodeBenchCharSequenceOld() {
        int h = 0;
        for (int i = 0; i < this.string.length(); ++i) {
            h = h * 31 + (this.string.charAt(i) & 0x1F);
        }
        return h;
    }

    @Benchmark
    public int hashCodeBenchCharSequenceNew() {
        return PlatformDependent.hashCodeAscii((CharSequence)this.string);
    }
}

