/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.websocket;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocket08FrameDecoder;
import io.netty.handler.codec.http.websocketx.WebSocket08FrameEncoder;
import io.netty.microbench.channel.EmbeddedChannelHandlerContext;
import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.microbench.util.AbstractMicrobenchmarkBase;
import java.util.concurrent.ThreadLocalRandom;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.profile.GCProfiler;
import org.openjdk.jmh.runner.options.ChainedOptionsBuilder;

@State(value=Scope.Benchmark)
@Fork(value=2)
@Threads(value=1)
@Warmup(iterations=5)
@Measurement(iterations=10)
public class WebSocketFrame08DecoderBenchmark
extends AbstractMicrobenchmark {
    private WebSocket08FrameDecoder websocketDecoder;
    private ChannelHandlerContext context;
    private ByteBuf websocketFrame;
    @Param(value={"0", "2", "4", "8", "32", "100", "1000", "3000"})
    public int contentLength;
    @Param(value={"true", "false"})
    public boolean pooledAllocator;
    @Param(value={"true"})
    public boolean masking;

    @Setup(value=Level.Trial)
    public void setUp() {
        byte[] bytes = new byte[this.contentLength];
        ThreadLocalRandom.current().nextBytes(bytes);
        PooledByteBufAllocator allocator = this.pooledAllocator ? PooledByteBufAllocator.DEFAULT : UnpooledByteBufAllocator.DEFAULT;
        ByteBuf testContent = allocator.buffer(this.contentLength).writeBytes(bytes);
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new WebSocket08FrameEncoder(this.masking)});
        channel.writeOutbound(new Object[]{new BinaryWebSocketFrame(testContent)});
        this.websocketFrame = Unpooled.unreleasableBuffer((ByteBuf)((ByteBuf)channel.readOutbound()).asReadOnly());
        channel.pipeline().remove(WebSocket08FrameEncoder.class);
        this.websocketDecoder = new WebSocket08FrameDecoder(this.masking, false, 65536);
        this.context = new EmbeddedChannelHandlerContext((ByteBufAllocator)allocator, (ChannelHandler)this.websocketDecoder, channel){

            @Override
            protected void handleException(Throwable t) {
                AbstractMicrobenchmarkBase.handleUnexpectedException(t);
            }
        };
    }

    @TearDown(value=Level.Trial)
    public void teardown() {
        this.websocketFrame.release();
        this.websocketFrame = null;
    }

    @Benchmark
    public void readWebSocketFrame() throws Exception {
        this.websocketDecoder.channelRead(this.context, (Object)this.websocketFrame.retainedDuplicate());
    }

    @Override
    protected ChainedOptionsBuilder newOptionsBuilder() throws Exception {
        return super.newOptionsBuilder().addProfiler(GCProfiler.class);
    }
}

