/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.microbench.util.AbstractMicrobenchmark;
import java.util.concurrent.TimeUnit;
import jdk.jfr.Event;
import jdk.jfr.consumer.RecordingStream;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.profile.GCProfiler;
import org.openjdk.jmh.runner.options.ChainedOptionsBuilder;

@Fork(value=1)
@BenchmarkMode(value={Mode.AverageTime})
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
@Measurement(time=10, timeUnit=TimeUnit.SECONDS)
public class JfrBenchmark
extends AbstractMicrobenchmark {
    @Param(value={"true", "false"})
    boolean enabled;
    private RecordingStream stream;

    @Override
    protected ChainedOptionsBuilder newOptionsBuilder() throws Exception {
        return super.newOptionsBuilder().addProfiler(GCProfiler.class);
    }

    @Setup
    public void setup() {
        this.stream = new RecordingStream();
        if (this.enabled) {
            this.stream.enable(NettyEvent.class.getName());
        } else {
            this.stream.disable(NettyEvent.class.getName());
        }
        this.stream.startAsync();
    }

    @TearDown
    public void teardown() {
        this.stream.close();
    }

    @Benchmark
    public void nettyEvent() {
        NettyEvent event = new NettyEvent();
        event.begin();
        event.end();
        event.foo = "bar";
        event.commit();
    }

    static final class NettyEvent
    extends Event {
        String foo;

        NettyEvent() {
        }
    }
}

