/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.DefaultHttp2FrameWriter;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2DataWriter;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.microbench.channel.EmbeddedChannelWriteReleaseHandlerContext;
import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.microbench.util.AbstractMicrobenchmarkBase;
import io.netty.util.internal.ObjectUtil;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;

@Fork(value=1)
@Warmup(iterations=5)
@Measurement(iterations=5)
@State(value=Scope.Benchmark)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class Http2FrameWriterDataBenchmark
extends AbstractMicrobenchmark {
    @Param(value={"64", "1024", "4096", "16384", "1048576", "4194304"})
    public int payloadSize;
    @Param(value={"0", "100", "255"})
    public int padding;
    @Param(value={"true", "false"})
    public boolean pooled;
    private ByteBuf payload;
    private ChannelHandlerContext ctx;
    private Http2DataWriter writer;
    private Http2DataWriter oldWriter;

    @Setup(value=Level.Trial)
    public void setup() {
        this.writer = new DefaultHttp2FrameWriter();
        this.oldWriter = new OldDefaultHttp2FrameWriter();
        this.payload = this.pooled ? ByteBufAllocator.DEFAULT.buffer(this.payloadSize) : Unpooled.buffer((int)this.payloadSize);
        this.payload.writeZero(this.payloadSize);
        this.ctx = new EmbeddedChannelWriteReleaseHandlerContext((ByteBufAllocator)(this.pooled ? ByteBufAllocator.DEFAULT : UnpooledByteBufAllocator.DEFAULT), (ChannelHandler)new ChannelInboundHandlerAdapter()){

            @Override
            protected void handleException(Throwable t) {
                AbstractMicrobenchmarkBase.handleUnexpectedException(t);
            }
        };
    }

    @TearDown(value=Level.Trial)
    public void teardown() throws Exception {
        if (this.payload != null) {
            this.payload.release();
        }
        if (this.ctx != null) {
            this.ctx.close();
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public void newWriter() {
        this.writer.writeData(this.ctx, 3, this.payload.retain(), this.padding, true, this.ctx.voidPromise());
        this.ctx.flush();
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public void oldWriter() {
        this.oldWriter.writeData(this.ctx, 3, this.payload.retain(), this.padding, true, this.ctx.voidPromise());
        this.ctx.flush();
    }

    private static final class OldDefaultHttp2FrameWriter
    implements Http2DataWriter {
        private static final ByteBuf ZERO_BUFFER = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.directBuffer((int)255).writeZero(255)).asReadOnly();
        private final int maxFrameSize = 16384;

        private OldDefaultHttp2FrameWriter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ChannelFuture writeData(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endStream, ChannelPromise promise) {
            Http2CodecUtil.SimpleChannelPromiseAggregator promiseAggregator = new Http2CodecUtil.SimpleChannelPromiseAggregator(promise, ctx.channel(), ctx.executor());
            DataFrameHeader header = new DataFrameHeader(ctx, streamId);
            boolean needToReleaseHeaders = true;
            boolean needToReleaseData = true;
            try {
                boolean lastFrame;
                ObjectUtil.checkPositive((int)streamId, (String)"streamId");
                Http2CodecUtil.verifyPadding((int)padding);
                int remainingData = data.readableBytes();
                do {
                    int frameDataBytes = Math.min(remainingData, 16384);
                    int framePaddingBytes = Math.min(padding, Math.max(0, 16383 - frameDataBytes));
                    lastFrame = (remainingData -= frameDataBytes) == 0 && (padding -= framePaddingBytes) == 0;
                    ByteBuf frameHeader = header.slice(frameDataBytes, framePaddingBytes, lastFrame && endStream);
                    needToReleaseHeaders = !lastFrame;
                    ctx.write((Object)(lastFrame ? frameHeader : frameHeader.retain()), promiseAggregator.newPromise());
                    ByteBuf frameData = data.readSlice(frameDataBytes);
                    needToReleaseData = !lastFrame;
                    ctx.write((Object)(lastFrame ? frameData : frameData.retain()), promiseAggregator.newPromise());
                    if (OldDefaultHttp2FrameWriter.paddingBytes(framePaddingBytes) <= 0) continue;
                    ctx.write((Object)ZERO_BUFFER.slice(0, OldDefaultHttp2FrameWriter.paddingBytes(framePaddingBytes)), promiseAggregator.newPromise());
                } while (!lastFrame);
            }
            catch (Throwable t) {
                try {
                    if (needToReleaseHeaders) {
                        header.release();
                    }
                    if (needToReleaseData) {
                        data.release();
                    }
                }
                finally {
                    promiseAggregator.setFailure(t);
                    promiseAggregator.doneAllocatingPromises();
                }
                return promiseAggregator;
            }
            return promiseAggregator.doneAllocatingPromises();
        }

        private static int paddingBytes(int padding) {
            return padding - 1;
        }

        private static void writePaddingLength(ByteBuf buf, int padding) {
            if (padding > 0) {
                buf.writeByte(padding - 1);
            }
        }

        private static final class DataFrameHeader {
            private final int streamId;
            private final ByteBuf buffer;
            private final Http2Flags flags = new Http2Flags();
            private int prevData;
            private int prevPadding;
            private ByteBuf frameHeader;

            DataFrameHeader(ChannelHandlerContext ctx, int streamId) {
                this.buffer = ctx.alloc().buffer(30);
                this.streamId = streamId;
            }

            ByteBuf slice(int data, int padding, boolean endOfStream) {
                if (data != this.prevData || padding != this.prevPadding || endOfStream != this.flags.endOfStream() || this.frameHeader == null) {
                    this.prevData = data;
                    this.prevPadding = padding;
                    this.flags.paddingPresent(padding > 0);
                    this.flags.endOfStream(endOfStream);
                    this.frameHeader = this.buffer.slice(this.buffer.readerIndex(), 10).writerIndex(0);
                    this.buffer.setIndex(this.buffer.readerIndex() + 10, this.buffer.writerIndex() + 10);
                    int payloadLength = data + padding;
                    Http2CodecUtil.writeFrameHeaderInternal((ByteBuf)this.frameHeader, (int)payloadLength, (byte)0, (Http2Flags)this.flags, (int)this.streamId);
                    OldDefaultHttp2FrameWriter.writePaddingLength(this.frameHeader, padding);
                }
                return this.frameHeader.slice();
            }

            void release() {
                this.buffer.release();
            }
        }
    }
}

