/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.ByteProcessor;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;

@Warmup(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=10, time=1, timeUnit=TimeUnit.SECONDS)
public class CompositeByteBufSequentialBenchmark
extends AbstractMicrobenchmark {
    @Param(value={"8", "64", "1024", "10240", "102400", "1024000"})
    public int size;
    @Param
    public ByteBufType bufferType;
    private ByteBuf buffer;
    private static final ByteProcessor TEST_PROCESSOR = new ByteProcessor(){

        public boolean process(byte value) throws Exception {
            return value == 98;
        }
    };

    @Setup
    public void setup() {
        this.buffer = this.bufferType.newBuffer(this.size);
    }

    @TearDown
    public void teardown() {
        this.buffer.release();
    }

    @Benchmark
    public int forEachByte() {
        this.buffer.setIndex(0, this.buffer.capacity());
        this.buffer.forEachByte(TEST_PROCESSOR);
        return this.buffer.forEachByteDesc(TEST_PROCESSOR);
    }

    @Benchmark
    public int sequentialWriteAndRead() {
        int i;
        this.buffer.clear();
        int l = this.buffer.writableBytes();
        for (i = 0; i < l; ++i) {
            this.buffer.writeByte(97);
        }
        l = this.buffer.readableBytes();
        for (i = 0; i < l; ++i) {
            if (this.buffer.readByte() != 98) continue;
            return -1;
        }
        return 1;
    }

    private static ByteBuf newBufferSmallChunks(int length) {
        ArrayList<ByteBuf> buffers = new ArrayList<ByteBuf>((length + 1) / 45 * 19);
        for (int i = 0; i < length + 45; i += 45) {
            for (int j = 1; j <= 9; ++j) {
                buffers.add(Unpooled.EMPTY_BUFFER);
                buffers.add(Unpooled.wrappedBuffer((byte[])new byte[j]));
            }
            buffers.add(Unpooled.EMPTY_BUFFER);
        }
        ByteBuf buffer = Unpooled.wrappedBuffer((int)Integer.MAX_VALUE, (ByteBuf[])buffers.toArray(new ByteBuf[0]));
        return buffer.capacity(length).writerIndex(0);
    }

    private static ByteBuf newBufferLargeChunks(int length) {
        ArrayList<ByteBuf> buffers = new ArrayList<ByteBuf>((length + 1) / 512);
        for (int i = 0; i < length + 1536; i += 1536) {
            buffers.add(Unpooled.wrappedBuffer((byte[])new byte[512]));
            buffers.add(Unpooled.EMPTY_BUFFER);
            buffers.add(Unpooled.wrappedBuffer((byte[])new byte[1024]));
        }
        ByteBuf buffer = Unpooled.wrappedBuffer((int)Integer.MAX_VALUE, (ByteBuf[])buffers.toArray(new ByteBuf[0]));
        return buffer.capacity(length).writerIndex(0);
    }

    public static enum ByteBufType {
        SMALL_CHUNKS{

            @Override
            ByteBuf newBuffer(int length) {
                return CompositeByteBufSequentialBenchmark.newBufferSmallChunks(length);
            }
        }
        ,
        LARGE_CHUNKS{

            @Override
            ByteBuf newBuffer(int length) {
                return CompositeByteBufSequentialBenchmark.newBufferLargeChunks(length);
            }
        };


        abstract ByteBuf newBuffer(int var1);
    }
}

