/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.microbench.util.AbstractMicrobenchmark;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.CompilerControl;
import org.openjdk.jmh.annotations.GroupThreads;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.infra.Blackhole;

@State(value=Scope.Benchmark)
public class AbstractReferenceCountedByteBufBenchmark
extends AbstractMicrobenchmark {
    @Param(value={"0", "1", "10", "100", "1000", "10000"})
    public int delay;
    AbstractReferenceCountedByteBuf buf;

    @Setup
    public void setUp() {
        this.buf = (AbstractReferenceCountedByteBuf)Unpooled.buffer((int)1);
    }

    @TearDown
    public void tearDown() {
        this.buf.release();
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    public boolean retainReleaseUncontended() {
        this.buf.retain();
        this.delay();
        return this.buf.release();
    }

    private void delay() {
        if (this.delay > 0) {
            Blackhole.consumeCPU((long)this.delay);
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    @CompilerControl(value=CompilerControl.Mode.DONT_INLINE)
    public boolean createUseAndRelease(Blackhole useBuffer) {
        ByteBuf unpooled = Unpooled.buffer((int)1);
        useBuffer.consume((Object)unpooled);
        this.delay();
        return unpooled.release();
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    @OutputTimeUnit(value=TimeUnit.NANOSECONDS)
    @GroupThreads(value=4)
    public boolean retainReleaseContended() {
        this.buf.retain();
        this.delay();
        return this.buf.release();
    }
}

