/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util;

import io.netty.util.AsciiString;
import io.netty.util.AsciiStringUtil;
import io.netty.util.internal.SuppressJava6Requirement;
import java.util.SplittableRandom;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

@Threads(value=1)
@OutputTimeUnit(value=TimeUnit.MICROSECONDS)
@Fork(value=2)
@Warmup(iterations=5, time=1)
@Measurement(iterations=8, time=1)
@State(value=Scope.Benchmark)
public class AsciiStringCaseConversionBenchmark {
    @Param(value={"7", "16", "23", "32"})
    int size;
    @Param(value={"4", "11"})
    int logPermutations;
    @Param(value={"0"})
    int seed;
    int permutations;
    AsciiString[] asciiStringData;
    String[] stringData;
    byte[] ret;
    private int i;
    @Param(value={"true", "false"})
    private boolean noUnsafe;

    @Setup(value=Level.Trial)
    @SuppressJava6Requirement(reason="using SplittableRandom to reliably produce data")
    public void init() {
        System.setProperty("io.netty.noUnsafe", Boolean.valueOf(this.noUnsafe).toString());
        SplittableRandom random = new SplittableRandom(this.seed);
        this.permutations = 1 << this.logPermutations;
        this.ret = new byte[this.size];
        this.asciiStringData = new AsciiString[this.permutations];
        this.stringData = new String[this.permutations];
        for (int i = 0; i < this.permutations; ++i) {
            int foundIndex = random.nextInt(Math.max(0, this.size - 8), this.size);
            byte[] byteArray = new byte[this.size];
            for (int j = 0; j < this.size; ++j) {
                int value = random.nextInt(0, 128);
                if (j < foundIndex && AsciiStringUtil.isUpperCase((byte)value)) {
                    value = AsciiStringUtil.toLowerCase((byte)value);
                }
                if (j == foundIndex) {
                    value = 78;
                }
                byteArray[j] = value;
            }
            this.asciiStringData[i] = new AsciiString(byteArray, false);
            this.stringData[i] = this.asciiStringData[i].toString();
        }
    }

    private AsciiString getData() {
        return this.asciiStringData[this.i++ & this.permutations - 1];
    }

    private String getStringData() {
        return this.stringData[this.i++ & this.permutations - 1];
    }

    @Benchmark
    public AsciiString toLowerCase() {
        return this.getData().toLowerCase();
    }

    @Benchmark
    public AsciiString toUpperCase() {
        return this.getData().toUpperCase();
    }

    @Benchmark
    public String stringToLowerCase() {
        return this.getStringData().toLowerCase();
    }

    @Benchmark
    public String stringtoUpperCase() {
        return this.getStringData().toUpperCase();
    }
}

