/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.util;

import io.netty.channel.EventLoop;
import io.netty.microbench.util.AbstractMicrobenchmarkBase;
import io.netty.util.concurrent.AbstractEventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ProgressivePromise;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Fork;

@Fork(value=1)
public class AbstractSharedExecutorMicrobenchmark
extends AbstractMicrobenchmarkBase {
    protected static final int DEFAULT_FORKS = 1;
    protected static final String[] JVM_ARGS;

    public static void executor(EventLoop eventLoop) {
        DelegateHarnessExecutor.executor(eventLoop);
    }

    @Override
    protected String[] jvmArgs() {
        return JVM_ARGS;
    }

    public static void handleUnexpectedException(Throwable t) {
        if (t != null) {
            throw new IllegalStateException(t);
        }
    }

    static {
        String[] customArgs = new String[]{"-Xms2g", "-Xmx2g", "-XX:MaxDirectMemorySize=2g", "-Djmh.executor=CUSTOM", "-Djmh.executor.class=io.netty.microbench.util.AbstractSharedExecutorMicrobenchmark$DelegateHarnessExecutor"};
        JVM_ARGS = new String[BASE_JVM_ARGS.length + customArgs.length];
        System.arraycopy(BASE_JVM_ARGS, 0, JVM_ARGS, 0, BASE_JVM_ARGS.length);
        System.arraycopy(customArgs, 0, JVM_ARGS, BASE_JVM_ARGS.length, customArgs.length);
    }

    public static final class DelegateHarnessExecutor
    extends AbstractEventExecutor {
        private static EventLoop executor;
        private static final InternalLogger logger;

        public DelegateHarnessExecutor(int maxThreads, String prefix) {
            logger.debug("Using DelegateHarnessExecutor executor {}", (Object)this);
        }

        public static void executor(EventLoop service) {
            executor = service;
        }

        public boolean inEventLoop() {
            return executor.inEventLoop();
        }

        public boolean inEventLoop(Thread thread) {
            return executor.inEventLoop(thread);
        }

        public Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
            return executor.shutdownGracefully(quietPeriod, timeout, unit);
        }

        public Future<?> terminationFuture() {
            return executor.terminationFuture();
        }

        @Deprecated
        public void shutdown() {
            executor.shutdown();
        }

        public boolean isShuttingDown() {
            return executor.isShuttingDown();
        }

        public boolean isShutdown() {
            return executor.isShutdown();
        }

        public boolean isTerminated() {
            return executor.isTerminated();
        }

        public boolean awaitTermination(long timeout, TimeUnit unit) {
            try {
                return executor.awaitTermination(timeout, unit);
            }
            catch (InterruptedException e) {
                AbstractSharedExecutorMicrobenchmark.handleUnexpectedException(e);
                return false;
            }
        }

        public void execute(Runnable command) {
            executor.execute(command);
        }

        public <V> Promise<V> newPromise() {
            return executor.newPromise();
        }

        public <V> ProgressivePromise<V> newProgressivePromise() {
            return executor.newProgressivePromise();
        }

        static {
            logger = InternalLoggerFactory.getInstance(DelegateHarnessExecutor.class);
        }
    }
}

