/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.headers;

import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpScheme;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.ReadOnlyHttp2Headers;
import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.AsciiString;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@Threads(value=1)
@State(value=Scope.Benchmark)
@Fork(value=2)
@Warmup(iterations=10)
@Measurement(iterations=10)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class ReadOnlyHttp2HeadersBenchmark
extends AbstractMicrobenchmark {
    private AsciiString[] headerNames;
    private AsciiString[] headerValues;
    @Param(value={"1", "5", "10", "20"})
    public int headerCount;
    private final AsciiString path = new AsciiString((CharSequence)"/BigDynamicPayload");
    private final AsciiString authority = new AsciiString((CharSequence)"io.netty");

    @Setup
    public void setUp() throws Exception {
        this.headerNames = new AsciiString[this.headerCount];
        this.headerValues = new AsciiString[this.headerCount];
        for (int i = 0; i < this.headerCount; ++i) {
            this.headerNames[i] = new AsciiString((CharSequence)("key-" + i));
            this.headerValues[i] = new AsciiString((CharSequence)UUID.randomUUID().toString());
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public void defaultTrailers(Blackhole bh) {
        DefaultHttp2Headers headers = new DefaultHttp2Headers(false);
        for (int i = 0; i < this.headerCount; ++i) {
            headers.add((Object)this.headerNames[i], (Object)this.headerValues[i]);
        }
        ReadOnlyHttp2HeadersBenchmark.iterate((Http2Headers)headers, bh);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public void readOnlyTrailers(Blackhole bh) {
        ReadOnlyHttp2HeadersBenchmark.iterate((Http2Headers)ReadOnlyHttp2Headers.trailers((boolean)false, (AsciiString[])this.buildPairs()), bh);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public void defaultClientHeaders(Blackhole bh) {
        DefaultHttp2Headers headers = new DefaultHttp2Headers(false);
        for (int i = 0; i < this.headerCount; ++i) {
            headers.add((Object)this.headerNames[i], (Object)this.headerValues[i]);
        }
        headers.method((CharSequence)HttpMethod.POST.asciiName());
        headers.scheme((CharSequence)HttpScheme.HTTPS.name());
        headers.path((CharSequence)this.path);
        headers.authority((CharSequence)this.authority);
        ReadOnlyHttp2HeadersBenchmark.iterate((Http2Headers)headers, bh);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public void readOnlyClientHeaders(Blackhole bh) {
        ReadOnlyHttp2HeadersBenchmark.iterate((Http2Headers)ReadOnlyHttp2Headers.clientHeaders((boolean)false, (AsciiString)HttpMethod.POST.asciiName(), (AsciiString)this.path, (AsciiString)HttpScheme.HTTPS.name(), (AsciiString)this.authority, (AsciiString[])this.buildPairs()), bh);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public void defaultServerHeaders(Blackhole bh) {
        DefaultHttp2Headers headers = new DefaultHttp2Headers(false);
        for (int i = 0; i < this.headerCount; ++i) {
            headers.add((Object)this.headerNames[i], (Object)this.headerValues[i]);
        }
        headers.status((CharSequence)HttpResponseStatus.OK.codeAsText());
        ReadOnlyHttp2HeadersBenchmark.iterate((Http2Headers)headers, bh);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public void readOnlyServerHeaders(Blackhole bh) {
        ReadOnlyHttp2HeadersBenchmark.iterate((Http2Headers)ReadOnlyHttp2Headers.serverHeaders((boolean)false, (AsciiString)HttpResponseStatus.OK.codeAsText(), (AsciiString[])this.buildPairs()), bh);
    }

    private static void iterate(Http2Headers headers, Blackhole bh) {
        for (Map.Entry entry : headers) {
            bh.consume((Object)entry);
        }
    }

    private AsciiString[] buildPairs() {
        AsciiString[] headerPairs = new AsciiString[this.headerCount * 2];
        int i = 0;
        int j = 0;
        while (i < this.headerCount) {
            headerPairs[j] = this.headerNames[i];
            headerPairs[++j] = this.headerValues[i];
            ++i;
            ++j;
        }
        return headerPairs;
    }
}

