/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.securechat;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.example.securechat.SecureChatServerInitializer;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.pkitesting.CertificateBuilder;
import io.netty.pkitesting.X509Bundle;
import javax.net.ssl.KeyManagerFactory;

public final class SecureChatServer {
    static final int PORT = Integer.parseInt(System.getProperty("port", "8992"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        X509Bundle ssc = new CertificateBuilder().subject("cn=localhost").setIsCertificateAuthority(true).buildSelfSigned();
        SslContext sslCtx = SslContextBuilder.forServer((KeyManagerFactory)ssc.toKeyManagerFactory()).build();
        MultiThreadIoEventLoopGroup group = new MultiThreadIoEventLoopGroup(NioIoHandler.newFactory());
        try {
            ServerBootstrap b = new ServerBootstrap();
            ((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)group).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new SecureChatServerInitializer(sslCtx));
            b.bind(PORT).sync().channel().closeFuture().sync();
        }
        finally {
            group.shutdownGracefully();
        }
    }
}

