/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.stomp.websocket;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URL;

@ChannelHandler.Sharable
public final class StompWebSocketClientPageHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    static final StompWebSocketClientPageHandler INSTANCE = new StompWebSocketClientPageHandler();

    private StompWebSocketClientPageHandler() {
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) {
        if (request.headers().contains((CharSequence)HttpHeaderNames.UPGRADE, (CharSequence)HttpHeaderValues.WEBSOCKET, true)) {
            ctx.fireChannelRead((Object)request.retain());
            return;
        }
        if (request.decoderResult().isFailure()) {
            DefaultFullHttpResponse badRequest = new DefaultFullHttpResponse(request.protocolVersion(), HttpResponseStatus.BAD_REQUEST);
            StompWebSocketClientPageHandler.sendResponse((HttpResponse)badRequest, ctx, true);
            return;
        }
        if (!StompWebSocketClientPageHandler.sendResource(request, ctx)) {
            DefaultFullHttpResponse notFound = new DefaultFullHttpResponse(request.protocolVersion(), HttpResponseStatus.NOT_FOUND);
            notFound.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)HttpHeaderValues.TEXT_PLAIN);
            String payload = "Requested resource " + request.uri() + " not found";
            notFound.content().writeCharSequence((CharSequence)payload, CharsetUtil.UTF_8);
            HttpUtil.setContentLength((HttpMessage)notFound, (long)notFound.content().readableBytes());
            StompWebSocketClientPageHandler.sendResponse((HttpResponse)notFound, ctx, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean sendResource(FullHttpRequest request, ChannelHandlerContext ctx) {
        URL resourceUrl;
        if (request.uri().isEmpty() || !request.uri().startsWith("/")) {
            return false;
        }
        String requestResource = request.uri().substring(1);
        if (requestResource.isEmpty()) {
            requestResource = "index.html";
        }
        if ((resourceUrl = ((Object)((Object)INSTANCE)).getClass().getResource(requestResource)) == null) {
            return false;
        }
        RandomAccessFile raf = null;
        long fileLength = -1L;
        try {
            raf = new RandomAccessFile(resourceUrl.getFile(), "r");
            fileLength = raf.length();
        }
        catch (FileNotFoundException fne) {
            System.out.println("File not found " + fne.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (IOException io) {
            System.out.println("Cannot read file length " + io.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileLength < 0L && raf != null) {
                try {
                    raf.close();
                }
                catch (IOException iOException) {}
            }
        }
        DefaultHttpResponse response = new DefaultHttpResponse(request.protocolVersion(), HttpResponseStatus.OK);
        HttpUtil.setContentLength((HttpMessage)response, (long)fileLength);
        String contentType = "application/octet-stream";
        if (requestResource.endsWith("html")) {
            contentType = "text/html; charset=UTF-8";
        } else if (requestResource.endsWith("css")) {
            contentType = "text/css; charset=UTF-8";
        } else if (requestResource.endsWith("js")) {
            contentType = "application/javascript";
        }
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
        StompWebSocketClientPageHandler.sendResponse((HttpResponse)response, ctx, false);
        ctx.write((Object)new DefaultFileRegion(raf.getChannel(), 0L, fileLength));
        ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        return true;
    }

    private static void sendResponse(HttpResponse response, ChannelHandlerContext ctx, boolean autoFlush) {
        if (HttpUtil.isKeepAlive((HttpMessage)response)) {
            if (response.protocolVersion().equals((Object)HttpVersion.HTTP_1_0)) {
                response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            }
            ctx.write((Object)response);
        } else {
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
            ctx.write((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
        if (autoFlush) {
            ctx.flush();
        }
    }
}

