/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.securechat;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.example.securechat.SecureChatServerHandler;
import io.netty.handler.codec.DelimiterBasedFrameDecoder;
import io.netty.handler.codec.Delimiters;
import io.netty.handler.codec.string.StringDecoder;
import io.netty.handler.codec.string.StringEncoder;
import io.netty.handler.ssl.SslContext;

public class SecureChatServerInitializer
extends ChannelInitializer<SocketChannel> {
    private final SslContext sslCtx;

    public SecureChatServerInitializer(SslContext sslCtx) {
        this.sslCtx = sslCtx;
    }

    public void initChannel(SocketChannel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast(new ChannelHandler[]{this.sslCtx.newHandler(ch.alloc())});
        pipeline.addLast(new ChannelHandler[]{new DelimiterBasedFrameDecoder(8192, Delimiters.lineDelimiter())});
        pipeline.addLast(new ChannelHandler[]{new StringDecoder()});
        pipeline.addLast(new ChannelHandler[]{new StringEncoder()});
        pipeline.addLast(new ChannelHandler[]{new SecureChatServerHandler()});
    }
}

