/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.redis;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.example.redis.RedisClientHandler;
import io.netty.handler.codec.redis.RedisArrayAggregator;
import io.netty.handler.codec.redis.RedisBulkStringAggregator;
import io.netty.handler.codec.redis.RedisDecoder;
import io.netty.handler.codec.redis.RedisEncoder;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;

public class RedisClient {
    private static final String HOST = System.getProperty("host", "127.0.0.1");
    private static final int PORT = Integer.parseInt(System.getProperty("port", "6379"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        MultiThreadIoEventLoopGroup group = new MultiThreadIoEventLoopGroup(NioIoHandler.newFactory());
        try {
            Bootstrap b = new Bootstrap();
            ((Bootstrap)((Bootstrap)b.group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline p = ch.pipeline();
                    p.addLast(new ChannelHandler[]{new RedisDecoder()});
                    p.addLast(new ChannelHandler[]{new RedisBulkStringAggregator()});
                    p.addLast(new ChannelHandler[]{new RedisArrayAggregator()});
                    p.addLast(new ChannelHandler[]{new RedisEncoder()});
                    p.addLast(new ChannelHandler[]{new RedisClientHandler()});
                }
            });
            Channel ch = b.connect(HOST, PORT).sync().channel();
            System.out.println("Enter Redis commands (quit to end)");
            ChannelFuture lastWriteFuture = null;
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            while (true) {
                String input;
                String line;
                String string = line = (input = in.readLine()) != null ? input.trim() : null;
                if (line == null || "quit".equalsIgnoreCase(line)) break;
                if (line.isEmpty()) continue;
                lastWriteFuture = ch.writeAndFlush((Object)line);
                lastWriteFuture.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (!future.isSuccess()) {
                            System.err.print("write failed: ");
                            future.cause().printStackTrace(System.err);
                        }
                    }
                });
            }
            ch.close().sync();
            if (lastWriteFuture != null) {
                lastWriteFuture.sync();
            }
        }
        finally {
            group.shutdownGracefully();
        }
    }
}

