/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.http2;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.internal.ObjectUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public final class Http2ExampleUtil {
    public static final String UPGRADE_RESPONSE_HEADER = "http-to-http2-upgrade";
    private static final int BLOCK_SIZE = 1024;

    private Http2ExampleUtil() {
    }

    public static int toInt(String string, int defaultValue) {
        if (string != null && !string.isEmpty()) {
            return Integer.parseInt(string);
        }
        return defaultValue;
    }

    public static ByteBuf toByteBuf(InputStream input) throws IOException {
        ByteBuf buf = Unpooled.buffer();
        int n = 0;
        while ((n = buf.writeBytes(input, 1024)) > 0) {
        }
        return buf;
    }

    public static String firstValue(QueryStringDecoder query, String key) {
        ObjectUtil.checkNotNull((Object)query, (String)"Query can't be null!");
        List values = (List)query.parameters().get(key);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return (String)values.get(0);
    }
}

