/*
 * Decompiled with CFR 0.152.
 */
package io.netty.example.mqtt.heartBeat;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.MultiThreadIoEventLoopGroup;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.example.mqtt.heartBeat.MqttHeartBeatBrokerHandler;
import io.netty.handler.codec.mqtt.MqttDecoder;
import io.netty.handler.codec.mqtt.MqttEncoder;
import io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.TimeUnit;

public final class MqttHeartBeatBroker {
    private MqttHeartBeatBroker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        MultiThreadIoEventLoopGroup bossGroup = new MultiThreadIoEventLoopGroup(1, NioIoHandler.newFactory());
        MultiThreadIoEventLoopGroup workerGroup = new MultiThreadIoEventLoopGroup(NioIoHandler.newFactory());
        try {
            ServerBootstrap b = new ServerBootstrap();
            b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup);
            b.option(ChannelOption.SO_BACKLOG, (Object)1024);
            b.channel(NioServerSocketChannel.class);
            b.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                protected void initChannel(SocketChannel ch) throws Exception {
                    ch.pipeline().addLast("encoder", (ChannelHandler)MqttEncoder.INSTANCE);
                    ch.pipeline().addLast("decoder", (ChannelHandler)new MqttDecoder());
                    ch.pipeline().addLast("heartBeatHandler", (ChannelHandler)new IdleStateHandler(45L, 0L, 0L, TimeUnit.SECONDS));
                    ch.pipeline().addLast("handler", (ChannelHandler)MqttHeartBeatBrokerHandler.INSTANCE);
                }
            });
            ChannelFuture f = b.bind(1883).sync();
            System.out.println("Broker initiated...");
            f.channel().closeFuture().sync();
        }
        finally {
            workerGroup.shutdownGracefully();
            bossGroup.shutdownGracefully();
        }
    }
}

